/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.rtmp;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class CreateSSLSocket {
    public static KeyStore createKeyStore(InputStream inputStream, String passPhrase) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(inputStream, passPhrase.toCharArray());
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Socket createSSlSocket(KeyStore keyStore, String host, int port) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sslContext.getSocketFactory().createSocket(host, port);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
            return null;
        }
    }
}

