/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.rtmp;

import android.media.MediaCodec;
import android.util.Log;
import com.github.faucamp.simplertmp.DefaultRtmpPublisher;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.ossrs.rtmp.ConnectCheckerRtmp;
import net.ossrs.rtmp.SrsAllocator;

public class SrsFlvMuxer {
    private static final int VIDEO_ALLOC_SIZE = 131072;
    private static final int AUDIO_ALLOC_SIZE = 4096;
    private volatile boolean connected = false;
    private DefaultRtmpPublisher publisher;
    private Thread worker;
    private final Object txFrameLock = new Object();
    private SrsFlv flv = new SrsFlv();
    private boolean needToFindKeyFrame = true;
    private SrsFlvFrame mVideoSequenceHeader;
    private SrsFlvFrame mAudioSequenceHeader;
    private SrsAllocator mVideoAllocator = new SrsAllocator(131072);
    private SrsAllocator mAudioAllocator = new SrsAllocator(4096);
    private ConcurrentLinkedQueue<SrsFlvFrame> mFlvTagCache = new ConcurrentLinkedQueue();
    private ConnectCheckerRtmp connectCheckerRtmp;
    private static final String TAG = "SrsFlvMuxer";
    private int asample_rate = 44100;

    public SrsFlvMuxer(ConnectCheckerRtmp connectCheckerRtmp) {
        this.connectCheckerRtmp = connectCheckerRtmp;
        this.publisher = new DefaultRtmpPublisher(connectCheckerRtmp);
    }

    public void setSpsPPs(ByteBuffer sps, ByteBuffer pps) {
        this.flv.setSpsPPs(sps, pps);
    }

    public void setAsample_rate(int asample_rate) {
        this.asample_rate = asample_rate;
    }

    public void setIsStereo(boolean isStereo) {
        int channel = isStereo ? 2 : 1;
        this.flv.setAchannel(channel);
    }

    public void setAuthorization(String user, String password) {
        this.publisher.setAuthorization(user, password);
    }

    public void setJksData(InputStream inputStreamJks, String passPhraseJks) {
        this.publisher.setJksData(inputStreamJks, passPhraseJks);
    }

    public AtomicInteger getVideoFrameCacheNumber() {
        return this.publisher == null ? null : this.publisher.getVideoFrameCacheNumber();
    }

    public void setVideoResolution(int width, int height) {
        if (this.publisher != null) {
            this.publisher.setVideoResolution(width, height);
        }
    }

    private void disconnect(ConnectCheckerRtmp connectChecker) {
        try {
            this.publisher.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.connected = false;
        this.mVideoSequenceHeader = null;
        this.mAudioSequenceHeader = null;
        connectChecker.onDisconnectRtmp();
        Log.i((String)TAG, (String)"worker: disconnect ok.");
    }

    private boolean connect(String url) {
        if (!this.connected) {
            Log.i((String)TAG, (String)String.format("worker: connecting to RTMP server by url=%s\n", url));
            if (this.publisher.connect(url)) {
                this.connected = this.publisher.publish("live");
            }
            this.mVideoSequenceHeader = null;
            this.mAudioSequenceHeader = null;
        }
        return this.connected;
    }

    private void sendFlvTag(SrsFlvFrame frame) {
        if (!this.connected || frame == null) {
            return;
        }
        if (frame.is_video()) {
            if (frame.is_keyframe()) {
                Log.i((String)TAG, (String)String.format("worker: send frame type=%d, dts=%d, size=%dB", frame.type, frame.dts, frame.flvTag.array().length));
            }
            this.publisher.publishVideoData(frame.flvTag.array(), frame.flvTag.size(), frame.dts);
            this.mVideoAllocator.release(frame.flvTag);
        } else if (frame.is_audio()) {
            this.publisher.publishAudioData(frame.flvTag.array(), frame.flvTag.size(), frame.dts);
            this.mAudioAllocator.release(frame.flvTag);
        }
    }

    public void start(final String rtmpUrl) {
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!SrsFlvMuxer.this.connect(rtmpUrl)) {
                    SrsFlvMuxer.this.connectCheckerRtmp.onConnectionFailedRtmp();
                    return;
                }
                SrsFlvMuxer.this.connectCheckerRtmp.onConnectionSuccessRtmp();
                while (!Thread.interrupted()) {
                    if (!SrsFlvMuxer.this.mFlvTagCache.isEmpty()) {
                        SrsFlvFrame frame = (SrsFlvFrame)SrsFlvMuxer.this.mFlvTagCache.poll();
                        if (frame.is_sequenceHeader()) {
                            if (frame.is_video()) {
                                SrsFlvMuxer.this.mVideoSequenceHeader = frame;
                                SrsFlvMuxer.this.sendFlvTag(SrsFlvMuxer.this.mVideoSequenceHeader);
                                continue;
                            }
                            if (!frame.is_audio()) continue;
                            SrsFlvMuxer.this.mAudioSequenceHeader = frame;
                            SrsFlvMuxer.this.sendFlvTag(SrsFlvMuxer.this.mAudioSequenceHeader);
                            continue;
                        }
                        if (frame.is_video() && SrsFlvMuxer.this.mVideoSequenceHeader != null) {
                            SrsFlvMuxer.this.sendFlvTag(frame);
                            continue;
                        }
                        if (!frame.is_audio() || SrsFlvMuxer.this.mAudioSequenceHeader == null) continue;
                        SrsFlvMuxer.this.sendFlvTag(frame);
                        continue;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.worker.start();
    }

    public void stop() {
        this.mFlvTagCache.clear();
        if (this.worker != null) {
            this.worker.interrupt();
            try {
                this.worker.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.worker.interrupt();
            }
            this.worker = null;
        }
        this.flv.reset();
        this.needToFindKeyFrame = true;
        Log.i((String)TAG, (String)"SrsFlvMuxer closed");
        new Thread(new Runnable(){

            @Override
            public void run() {
                SrsFlvMuxer.this.disconnect(SrsFlvMuxer.this.connectCheckerRtmp);
            }
        }).start();
    }

    public void sendVideo(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        this.flv.writeVideoSample(byteBuffer, bufferInfo);
    }

    public void sendAudio(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        this.flv.writeAudioSample(byteBuffer, bufferInfo);
    }

    private class SrsFlv {
        private SrsRawH264Stream avc;
        private ArrayList<SrsFlvFrameBytes> ipbs;
        private SrsAllocator.Allocation audio_tag;
        private SrsAllocator.Allocation video_tag;
        private ByteBuffer h264_sps;
        private boolean h264_sps_changed;
        private ByteBuffer h264_pps;
        private boolean h264_pps_changed;
        private boolean h264_sps_pps_sent;
        private boolean aac_specific_config_got;
        private int achannel;

        public SrsFlv() {
            this.avc = new SrsRawH264Stream();
            this.ipbs = new ArrayList();
            this.achannel = 2;
            this.reset();
        }

        public void setAchannel(int achannel) {
            this.achannel = achannel;
        }

        public void reset() {
            this.h264_sps_changed = false;
            this.h264_pps_changed = false;
            this.h264_sps_pps_sent = false;
            this.aac_specific_config_got = false;
        }

        public void writeAudioSample(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            int pts;
            int dts = pts = (int)(bi.presentationTimeUs / 1000L);
            this.audio_tag = SrsFlvMuxer.this.mAudioAllocator.allocate(bi.size + 2);
            byte aac_packet_type = 1;
            if (!this.aac_specific_config_got) {
                byte ch = (byte)(bb.get(0) & 0xF8);
                int samplingFrequencyIndex = 4;
                if (SrsFlvMuxer.this.asample_rate == 2) {
                    samplingFrequencyIndex = 7;
                } else if (SrsFlvMuxer.this.asample_rate == 1) {
                    samplingFrequencyIndex = 10;
                }
                ch = (byte)(ch | samplingFrequencyIndex >> 1 & 7);
                this.audio_tag.put(ch, 2);
                ch = (byte)(samplingFrequencyIndex << 7 & 0x80);
                int channelConfiguration = 1;
                if (this.achannel == 2) {
                    channelConfiguration = 2;
                }
                ch = (byte)(ch | channelConfiguration << 3 & 0x78);
                this.audio_tag.put(ch, 3);
                this.aac_specific_config_got = true;
                aac_packet_type = 0;
                this.writeAdtsHeader(this.audio_tag.array(), 4);
                this.audio_tag.appendOffset(7);
            } else {
                bb.get(this.audio_tag.array(), 2, bi.size);
                this.audio_tag.appendOffset(bi.size + 2);
            }
            int sound_format = 10;
            boolean sound_type = false;
            if (this.achannel == 2) {
                sound_type = true;
            }
            int sound_size = 1;
            int sound_rate = 3;
            if (SrsFlvMuxer.this.asample_rate == 22050) {
                sound_rate = 2;
            } else if (SrsFlvMuxer.this.asample_rate == 11025) {
                sound_rate = 1;
            }
            byte audio_header = (byte)((sound_type ? 1 : 0) & 1);
            audio_header = (byte)(audio_header | sound_size << 1 & 2);
            audio_header = (byte)(audio_header | sound_rate << 2 & 0xC);
            audio_header = (byte)(audio_header | sound_format << 4 & 0xF0);
            this.audio_tag.put(audio_header, 0);
            this.audio_tag.put(aac_packet_type, 1);
            this.writeRtmpPacket(8, dts, 0, aac_packet_type, this.audio_tag);
        }

        private void writeAdtsHeader(byte[] frame, int offset) {
            frame[offset] = -1;
            frame[offset + 1] = -16;
            int n = offset + 1;
            frame[n] = (byte)(frame[n] | 0);
            int n2 = offset + 1;
            frame[n2] = (byte)(frame[n2] | 0);
            int n3 = offset + 1;
            frame[n3] = (byte)(frame[n3] | 1);
            frame[offset + 2] = 64;
            int n4 = offset + 2;
            frame[n4] = (byte)(frame[n4] | 0x10);
            int n5 = offset + 2;
            frame[n5] = (byte)(frame[n5] | 0);
            frame[offset + 3] = -128;
            int n6 = offset + 3;
            frame[n6] = (byte)(frame[n6] | 0);
            int n7 = offset + 3;
            frame[n7] = (byte)(frame[n7] | 0);
            int n8 = offset + 3;
            frame[n8] = (byte)(frame[n8] | 0);
            int n9 = offset + 3;
            frame[n9] = (byte)(frame[n9] | 0);
            int n10 = offset + 3;
            frame[n10] = (byte)(frame[n10] | (frame.length - 2 & 0x1800) >> 11);
            frame[offset + 4] = (byte)((frame.length - 2 & 0x7F8) >> 3);
            frame[offset + 5] = (byte)((frame.length - 2 & 7) << 5);
            int n11 = offset + 5;
            frame[n11] = (byte)(frame[n11] | 0x1F);
            frame[offset + 6] = -4;
            int n12 = offset + 6;
            frame[n12] = (byte)(frame[n12] | 0);
        }

        public void writeVideoSample(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            int pts;
            int dts = pts = (int)(bi.presentationTimeUs / 1000L);
            int type = 2;
            while (bb.position() < bi.size) {
                SrsFlvFrameBytes frame = this.avc.demuxAnnexb(bb, bi);
                int nal_unit_type = frame.data.get(0) & 0x1F;
                if (nal_unit_type == 7 || nal_unit_type == 8) {
                    Log.i((String)SrsFlvMuxer.TAG, (String)String.format("annexb demux %dB, pts=%d, frame=%dB, nalu=%d", bi.size, pts, frame.size, nal_unit_type));
                }
                if (nal_unit_type == 5) {
                    type = 1;
                }
                if (nal_unit_type == 9) continue;
                this.ipbs.add(this.avc.muxNaluHeader(frame));
                this.ipbs.add(frame);
            }
            this.writeH264SpsPps(dts, pts);
            this.writeH264IpbFrame(this.ipbs, type, dts, pts);
            this.ipbs.clear();
        }

        public void setSpsPPs(ByteBuffer sps, ByteBuffer pps) {
            this.h264_sps_changed = true;
            this.h264_sps = sps;
            this.h264_pps_changed = true;
            this.h264_pps = pps;
        }

        private void writeH264SpsPps(int dts, int pts) {
            if (this.h264_sps_pps_sent && !this.h264_sps_changed && !this.h264_pps_changed) {
                return;
            }
            if (this.h264_pps == null || this.h264_sps == null) {
                return;
            }
            ArrayList<SrsFlvFrameBytes> frames = new ArrayList<SrsFlvFrameBytes>();
            this.avc.muxSequenceHeader(this.h264_sps, this.h264_pps, dts, pts, frames);
            int frame_type = 1;
            int avc_packet_type = 0;
            this.video_tag = this.avc.muxFlvTag(frames, frame_type, avc_packet_type, dts, pts);
            this.writeRtmpPacket(9, dts, frame_type, avc_packet_type, this.video_tag);
            this.h264_sps_changed = false;
            this.h264_pps_changed = false;
            this.h264_sps_pps_sent = true;
            Log.i((String)SrsFlvMuxer.TAG, (String)String.format("flv: h264 sps/pps sent, sps=%dB, pps=%dB", this.h264_sps.array().length, this.h264_pps.array().length));
        }

        private void writeH264IpbFrame(ArrayList<SrsFlvFrameBytes> frames, int frame_type, int dts, int pts) {
            if (!this.h264_sps_pps_sent) {
                return;
            }
            int avc_packet_type = 1;
            this.video_tag = this.avc.muxFlvTag(frames, frame_type, avc_packet_type, dts, pts);
            this.writeRtmpPacket(9, dts, frame_type, avc_packet_type, this.video_tag);
        }

        private void writeRtmpPacket(int type, int dts, int frame_type, int avc_aac_type, SrsAllocator.Allocation tag) {
            SrsFlvFrame frame = new SrsFlvFrame();
            frame.flvTag = tag;
            frame.type = type;
            frame.dts = dts;
            frame.frame_type = frame_type;
            frame.avc_aac_type = avc_aac_type;
            if (frame.is_video()) {
                if (SrsFlvMuxer.this.needToFindKeyFrame) {
                    if (frame.is_keyframe()) {
                        SrsFlvMuxer.this.needToFindKeyFrame = false;
                        this.flvFrameCacheAdd(frame);
                    }
                } else {
                    this.flvFrameCacheAdd(frame);
                }
            } else if (frame.is_audio()) {
                this.flvFrameCacheAdd(frame);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flvFrameCacheAdd(SrsFlvFrame frame) {
            SrsFlvMuxer.this.mFlvTagCache.add(frame);
            if (frame.is_video()) {
                SrsFlvMuxer.this.getVideoFrameCacheNumber().incrementAndGet();
            }
            Object object = SrsFlvMuxer.this.txFrameLock;
            synchronized (object) {
                SrsFlvMuxer.this.txFrameLock.notifyAll();
            }
        }
    }

    private class SrsRawH264Stream {
        private static final String TAG = "SrsFlvMuxer";
        private SrsUtils utils;
        private SrsFlvFrameBytes nalu_header;
        private SrsFlvFrameBytes seq_hdr;
        private SrsFlvFrameBytes sps_hdr;
        private SrsFlvFrameBytes sps_bb;
        private SrsFlvFrameBytes pps_hdr;
        private SrsFlvFrameBytes pps_bb;

        private SrsRawH264Stream() {
            this.utils = new SrsUtils();
            this.nalu_header = new SrsFlvFrameBytes();
            this.seq_hdr = new SrsFlvFrameBytes();
            this.sps_hdr = new SrsFlvFrameBytes();
            this.sps_bb = new SrsFlvFrameBytes();
            this.pps_hdr = new SrsFlvFrameBytes();
            this.pps_bb = new SrsFlvFrameBytes();
        }

        public boolean isSps(SrsFlvFrameBytes frame) {
            return frame.size >= 1 && (frame.data.get(0) & 0x1F) == 7;
        }

        public boolean isPps(SrsFlvFrameBytes frame) {
            return frame.size >= 1 && (frame.data.get(0) & 0x1F) == 8;
        }

        public SrsFlvFrameBytes muxNaluHeader(SrsFlvFrameBytes frame) {
            if (this.nalu_header.data == null) {
                this.nalu_header.data = ByteBuffer.allocate(4);
                this.nalu_header.size = 4;
            }
            this.nalu_header.data.rewind();
            int NAL_unit_length = frame.size;
            this.nalu_header.data.putInt(NAL_unit_length);
            this.nalu_header.data.rewind();
            return this.nalu_header;
        }

        public void muxSequenceHeader(ByteBuffer sps, ByteBuffer pps, int dts, int pts, ArrayList<SrsFlvFrameBytes> frames) {
            if (this.seq_hdr.data == null) {
                this.seq_hdr.data = ByteBuffer.allocate(5);
                this.seq_hdr.size = 5;
            }
            this.seq_hdr.data.rewind();
            byte profile_idc = sps.get(1);
            byte level_idc = sps.get(3);
            this.seq_hdr.data.put((byte)1);
            this.seq_hdr.data.put(profile_idc);
            this.seq_hdr.data.put((byte)0);
            this.seq_hdr.data.put(level_idc);
            this.seq_hdr.data.put((byte)3);
            this.seq_hdr.data.rewind();
            frames.add(this.seq_hdr);
            if (this.sps_hdr.data == null) {
                this.sps_hdr.data = ByteBuffer.allocate(3);
                this.sps_hdr.size = 3;
            }
            this.sps_hdr.data.rewind();
            this.sps_hdr.data.put((byte)1);
            this.sps_hdr.data.putShort((short)sps.array().length);
            this.sps_hdr.data.rewind();
            frames.add(this.sps_hdr);
            this.sps_bb.size = sps.array().length;
            this.sps_bb.data = sps.duplicate();
            frames.add(this.sps_bb);
            if (this.pps_hdr.data == null) {
                this.pps_hdr.data = ByteBuffer.allocate(3);
                this.pps_hdr.size = 3;
            }
            this.pps_hdr.data.rewind();
            this.pps_hdr.data.put((byte)1);
            this.pps_hdr.data.putShort((short)pps.array().length);
            this.pps_hdr.data.rewind();
            frames.add(this.pps_hdr);
            this.pps_bb.size = pps.array().length;
            this.pps_bb.data = pps.duplicate();
            frames.add(this.pps_bb);
        }

        public SrsAllocator.Allocation muxFlvTag(ArrayList<SrsFlvFrameBytes> frames, int frame_type, int avc_packet_type, int dts, int pts) {
            int size = 5;
            for (int i = 0; i < frames.size(); ++i) {
                size += frames.get((int)i).size;
            }
            SrsAllocator.Allocation allocation = SrsFlvMuxer.this.mVideoAllocator.allocate(size);
            allocation.put((byte)(frame_type << 4 | 7));
            allocation.put((byte)avc_packet_type);
            int cts = pts - dts;
            allocation.put((byte)(cts >> 16));
            allocation.put((byte)(cts >> 8));
            allocation.put((byte)cts);
            for (int i = 0; i < frames.size(); ++i) {
                SrsFlvFrameBytes frame = frames.get(i);
                frame.data.get(allocation.array(), allocation.size(), frame.size);
                allocation.appendOffset(frame.size);
            }
            return allocation;
        }

        public SrsFlvFrameBytes demuxAnnexb(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            SrsFlvFrameBytes tbb;
            block3: {
                tbb = new SrsFlvFrameBytes();
                if (bb.position() >= bi.size) break block3;
                SrsAnnexbSearch tbbsc = this.utils.avc_startswith_annexb(bb, bi);
                if (!tbbsc.match || tbbsc.nb_start_code < 3) {
                    Log.e((String)"SrsFlvMuxer", (String)"annexb not match.");
                }
                for (int i = 0; i < tbbsc.nb_start_code; ++i) {
                    bb.get();
                }
                tbb.data = bb.slice();
                int pos = bb.position();
                while (bb.position() < bi.size) {
                    SrsAnnexbSearch bsc = this.utils.avc_startswith_annexb(bb, bi);
                    if (bsc.match) break;
                    bb.get();
                }
                tbb.size = bb.position() - pos;
            }
            return tbb;
        }
    }

    private class SrsFlvFrame {
        public SrsAllocator.Allocation flvTag;
        public int avc_aac_type;
        public int frame_type;
        public int type;
        public int dts;

        private SrsFlvFrame() {
        }

        public boolean is_keyframe() {
            return this.is_video() && this.frame_type == 1;
        }

        public boolean is_sequenceHeader() {
            return this.avc_aac_type == 0;
        }

        public boolean is_video() {
            return this.type == 9;
        }

        public boolean is_audio() {
            return this.type == 8;
        }
    }

    private class SrsFlvFrameBytes {
        public ByteBuffer data;
        public int size;

        private SrsFlvFrameBytes() {
        }
    }

    private class SrsAnnexbSearch {
        public int nb_start_code = 0;
        public boolean match = false;

        private SrsAnnexbSearch() {
        }
    }

    public class SrsUtils {
        private SrsAnnexbSearch as;

        public SrsUtils() {
            this.as = new SrsAnnexbSearch();
        }

        public SrsAnnexbSearch avc_startswith_annexb(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            this.as.match = false;
            this.as.nb_start_code = 0;
            for (int i = bb.position(); i < bi.size - 3 && bb.get(i) == 0 && bb.get(i + 1) == 0; ++i) {
                if (bb.get(i + 2) != 1) continue;
                this.as.match = true;
                this.as.nb_start_code = i + 3 - bb.position();
                break;
            }
            return this.as;
        }
    }

    private class SrsAvcNaluType {
        public static final int IDR = 5;
        public static final int SPS = 7;
        public static final int PPS = 8;
        public static final int AccessUnitDelimiter = 9;

        private SrsAvcNaluType() {
        }
    }

    private class SrsAacObjectType {
        public static final int AacLC = 2;

        private SrsAacObjectType() {
        }
    }

    private class SrsCodecVideo {
        public static final int AVC = 7;

        private SrsCodecVideo() {
        }
    }

    private class SrsCodecAudioSampleRate {
        public static final int Reserved = 4;
        public static final int R5512 = 0;
        public static final int R11025 = 1;
        public static final int R22050 = 2;
        public static final int R44100 = 3;

        private SrsCodecAudioSampleRate() {
        }
    }

    private class SrsCodecFlvTag {
        public static final int Audio = 8;
        public static final int Video = 9;

        private SrsCodecFlvTag() {
        }
    }

    private class SrsCodecVideoAVCType {
        public static final int SequenceHeader = 0;
        public static final int NALU = 1;

        private SrsCodecVideoAVCType() {
        }
    }

    private class SrsCodecVideoAVCFrame {
        public static final int KeyFrame = 1;
        public static final int InterFrame = 2;

        private SrsCodecVideoAVCFrame() {
        }
    }
}

