/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.amf.v0;

import com.pedro.common.ExtensionsKt;
import com.pedro.rtmp.amf.v0.AmfData;
import com.pedro.rtmp.amf.v0.AmfType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/pedro/rtmp/amf/v0/AmfString;", "Lcom/pedro/rtmp/amf/v0/AmfData;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "setValue", "bodySize", "", "readBody", "", "input", "Ljava/io/InputStream;", "writeBody", "output", "Ljava/io/OutputStream;", "getType", "Lcom/pedro/rtmp/amf/v0/AmfType;", "getSize", "toString", "rtmp_release"})
public final class AmfString
extends AmfData {
    @NotNull
    private String value;
    private int bodySize;

    public AmfString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        byte[] byArray = this.value.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.bodySize = byArray.length + 2;
    }

    public /* synthetic */ AmfString(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final void setValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.value = string;
    }

    @Override
    public void readBody(@NotNull InputStream input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.bodySize = ExtensionsKt.readUInt16((InputStream)input);
        byte[] bytes = new byte[this.bodySize];
        this.bodySize += 2;
        ExtensionsKt.readUntil((InputStream)input, (byte[])bytes);
        this.value = new String(bytes, Charsets.UTF_8);
    }

    @Override
    public void writeBody(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ExtensionsKt.writeUInt16((OutputStream)output, (int)(this.bodySize - 2));
        byte[] byArray = this.value.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        output.write(bytes);
    }

    @Override
    @NotNull
    public AmfType getType() {
        return AmfType.STRING;
    }

    @Override
    public int getSize() {
        return this.bodySize;
    }

    @NotNull
    public String toString() {
        return "AmfString value: " + this.value;
    }

    public AmfString() {
        this(null, 1, null);
    }
}

