/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video.config;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/pedro/rtmp/flv/video/config/VideoSpecificConfigAVC;", "", "sps", "", "pps", "<init>", "([B[B)V", "size", "", "getSize", "()I", "write", "", "buffer", "offset", "calculateSize", "rtmp_release"})
public final class VideoSpecificConfigAVC {
    @NotNull
    private final byte[] sps;
    @NotNull
    private final byte[] pps;
    private final int size;

    public VideoSpecificConfigAVC(@NotNull byte[] sps, @NotNull byte[] pps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.sps = sps;
        this.pps = pps;
        this.size = this.calculateSize(this.sps, this.pps);
    }

    public final int getSize() {
        return this.size;
    }

    public final void write(@NotNull byte[] buffer, int offset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer data = ByteBuffer.wrap(buffer, offset, this.size);
        data.put((byte)1);
        byte profileIdc = this.sps[1];
        data.put(profileIdc);
        byte profileCompatibility = this.sps[2];
        data.put(profileCompatibility);
        byte levelIdc = this.sps[3];
        data.put(levelIdc);
        data.put((byte)-1);
        data.put((byte)-31);
        data.putShort((short)this.sps.length);
        data.put(this.sps);
        data.put((byte)1);
        data.putShort((short)this.pps.length);
        data.put(this.pps);
    }

    private final int calculateSize(byte[] sps, byte[] pps) {
        return 8 + sps.length + 3 + pps.length;
    }
}

