/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.amf.v0;

import com.pedro.rtmp.amf.v0.AmfData;
import com.pedro.rtmp.amf.v0.AmfType;
import com.pedro.rtmp.utils.UtilsKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lcom/pedro/rtmp/amf/v0/AmfNumber;", "Lcom/pedro/rtmp/amf/v0/AmfData;", "value", "", "<init>", "(D)V", "getValue", "()D", "setValue", "readBody", "", "input", "Ljava/io/InputStream;", "writeBody", "output", "Ljava/io/OutputStream;", "getType", "Lcom/pedro/rtmp/amf/v0/AmfType;", "getSize", "", "toString", "", "rtmp_release"})
public final class AmfNumber
extends AmfData {
    private double value;

    public AmfNumber(double value) {
        this.value = value;
    }

    public /* synthetic */ AmfNumber(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        this(d);
    }

    public final double getValue() {
        return this.value;
    }

    public final void setValue(double d) {
        this.value = d;
    }

    @Override
    public void readBody(@NotNull InputStream input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] bytes = new byte[this.getSize()];
        UtilsKt.readUntil(input, bytes);
        long value = ByteBuffer.wrap(bytes).getLong();
        this.value = Double.longBitsToDouble(value);
    }

    @Override
    public void writeBody(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getSize()).putLong(Double.doubleToRawLongBits(this.value));
        output.write(byteBuffer.array());
    }

    @Override
    @NotNull
    public AmfType getType() {
        return AmfType.NUMBER;
    }

    @Override
    public int getSize() {
        return 8;
    }

    @NotNull
    public String toString() {
        return "AmfNumber value: " + this.value;
    }

    public AmfNumber() {
        this(0.0, 1, null);
    }
}

