/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video.config;

import com.pedro.rtmp.utils.BitBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020(R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001a\u0010!\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0006\"\u0004\b#\u0010\b\u00a8\u0006)"}, d2={"Lcom/pedro/rtmp/flv/video/config/SPSH265Parser;", "", "()V", "bitDepthChromaMinus8", "", "getBitDepthChromaMinus8", "()I", "setBitDepthChromaMinus8", "(I)V", "bitDepthLumaMinus8", "getBitDepthLumaMinus8", "setBitDepthLumaMinus8", "chromaFormat", "getChromaFormat", "setChromaFormat", "generalConstraintIndicatorFlags", "", "getGeneralConstraintIndicatorFlags", "()J", "setGeneralConstraintIndicatorFlags", "(J)V", "generalLevelIdc", "getGeneralLevelIdc", "setGeneralLevelIdc", "generalProfileCompatibilityFlags", "getGeneralProfileCompatibilityFlags", "setGeneralProfileCompatibilityFlags", "generalProfileIdc", "getGeneralProfileIdc", "setGeneralProfileIdc", "generalProfileSpace", "getGeneralProfileSpace", "setGeneralProfileSpace", "generalTierFlag", "getGeneralTierFlag", "setGeneralTierFlag", "parse", "", "sps", "Ljava/nio/ByteBuffer;", "", "rtmp_release"})
public final class SPSH265Parser {
    private int generalProfileSpace;
    private int generalTierFlag;
    private int generalProfileIdc;
    private int generalProfileCompatibilityFlags;
    private long generalConstraintIndicatorFlags;
    private int generalLevelIdc;
    private int chromaFormat;
    private int bitDepthLumaMinus8;
    private int bitDepthChromaMinus8;

    public final int getGeneralProfileSpace() {
        return this.generalProfileSpace;
    }

    public final void setGeneralProfileSpace(int n) {
        this.generalProfileSpace = n;
    }

    public final int getGeneralTierFlag() {
        return this.generalTierFlag;
    }

    public final void setGeneralTierFlag(int n) {
        this.generalTierFlag = n;
    }

    public final int getGeneralProfileIdc() {
        return this.generalProfileIdc;
    }

    public final void setGeneralProfileIdc(int n) {
        this.generalProfileIdc = n;
    }

    public final int getGeneralProfileCompatibilityFlags() {
        return this.generalProfileCompatibilityFlags;
    }

    public final void setGeneralProfileCompatibilityFlags(int n) {
        this.generalProfileCompatibilityFlags = n;
    }

    public final long getGeneralConstraintIndicatorFlags() {
        return this.generalConstraintIndicatorFlags;
    }

    public final void setGeneralConstraintIndicatorFlags(long l) {
        this.generalConstraintIndicatorFlags = l;
    }

    public final int getGeneralLevelIdc() {
        return this.generalLevelIdc;
    }

    public final void setGeneralLevelIdc(int n) {
        this.generalLevelIdc = n;
    }

    public final int getChromaFormat() {
        return this.chromaFormat;
    }

    public final void setChromaFormat(int n) {
        this.chromaFormat = n;
    }

    public final int getBitDepthLumaMinus8() {
        return this.bitDepthLumaMinus8;
    }

    public final void setBitDepthLumaMinus8(int n) {
        this.bitDepthLumaMinus8 = n;
    }

    public final int getBitDepthChromaMinus8() {
        return this.bitDepthChromaMinus8;
    }

    public final void setBitDepthChromaMinus8(int n) {
        this.bitDepthChromaMinus8 = n;
    }

    public final void parse(@NotNull byte[] sps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        ByteBuffer byteBuffer = ByteBuffer.wrap(sps);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(sps)");
        this.parse(byteBuffer);
    }

    public final void parse(@NotNull ByteBuffer sps) {
        int i;
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        ByteBuffer rbsp = BitBuffer.Companion.extractRbsp(sps, 2);
        BitBuffer bitBuffer = new BitBuffer(rbsp);
        bitBuffer.getLong(16);
        bitBuffer.get(4);
        int maxSubLayersMinus1 = bitBuffer.get(3);
        bitBuffer.get(1);
        this.generalProfileSpace = bitBuffer.get(2);
        this.generalTierFlag = bitBuffer.getBool() ? 1 : 0;
        this.generalProfileIdc = bitBuffer.getShort(5);
        this.generalProfileCompatibilityFlags = bitBuffer.getInt(32);
        this.generalConstraintIndicatorFlags = bitBuffer.getLong(48);
        this.generalLevelIdc = bitBuffer.get(8);
        List subLayerProfilePresentFlag = new ArrayList();
        List subLayerLevelPresentFlag = new ArrayList();
        int n = maxSubLayersMinus1;
        for (i = 0; i < n; ++i) {
            subLayerProfilePresentFlag.add(bitBuffer.getBool());
            subLayerLevelPresentFlag.add(bitBuffer.getBool());
        }
        if (maxSubLayersMinus1 > 0) {
            for (i = maxSubLayersMinus1; i < 9; ++i) {
                bitBuffer.getLong(2);
            }
        }
        n = maxSubLayersMinus1;
        for (i = 0; i < n; ++i) {
            if (((Boolean)subLayerProfilePresentFlag.get(i)).booleanValue()) {
                bitBuffer.getLong(32);
                bitBuffer.getLong(32);
                bitBuffer.getLong(24);
            }
            if (!((Boolean)subLayerLevelPresentFlag.get(i)).booleanValue()) continue;
            bitBuffer.getLong(8);
        }
        bitBuffer.readUE();
        this.chromaFormat = bitBuffer.readUE();
        if (this.chromaFormat == 3) {
            bitBuffer.getBool();
        }
        bitBuffer.readUE();
        bitBuffer.readUE();
        boolean conformanceWindowFlag = bitBuffer.getBool();
        if (conformanceWindowFlag) {
            bitBuffer.readUE();
            bitBuffer.readUE();
            bitBuffer.readUE();
            bitBuffer.readUE();
        }
        this.bitDepthLumaMinus8 = bitBuffer.readUE();
        this.bitDepthChromaMinus8 = bitBuffer.readUE();
    }
}

