/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.audio.packet;

import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.rtmp.flv.BasePacket;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.audio.AudioFormat;
import com.pedro.rtmp.flv.audio.AudioSize;
import com.pedro.rtmp.flv.audio.AudioSoundRate;
import com.pedro.rtmp.flv.audio.AudioSoundType;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\"\u0010\u000b\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\b\b\u0002\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcom/pedro/rtmp/flv/audio/packet/G711Packet;", "Lcom/pedro/rtmp/flv/BasePacket;", "()V", "audioSize", "Lcom/pedro/rtmp/flv/audio/AudioSize;", "header", "", "createFlvPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "Lcom/pedro/rtmp/flv/FlvPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reset", "resetInfo", "", "sendAudioInfo", "rtmp_release"})
public final class G711Packet
extends BasePacket {
    @NotNull
    private final byte[] header = new byte[1];
    @NotNull
    private AudioSize audioSize = AudioSize.SND_16_BIT;

    public final void sendAudioInfo(@NotNull AudioSize audioSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioSize), (String)"audioSize");
        this.audioSize = audioSize;
    }

    public static /* synthetic */ void sendAudioInfo$default(G711Packet g711Packet, AudioSize audioSize, int n, Object object) {
        if ((n & 1) != 0) {
            audioSize = AudioSize.SND_16_BIT;
        }
        g711Packet.sendAudioInfo(audioSize);
    }

    @Override
    @Nullable
    public Object createFlvPacket(@NotNull MediaFrame mediaFrame2, @NotNull Function2<? super FlvPacket, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)mediaFrame2.getData(), (MediaFrame.Info)mediaFrame2.getInfo());
        this.header[0] = (byte)((byte)((byte)(AudioSoundType.MONO.getValue() | (byte)(this.audioSize.getValue() << 1)) | (byte)(AudioSoundRate.SR_5_5K.getValue() << 2)) | (byte)(AudioFormat.G711_A.getValue() << 4));
        byte[] buffer = new byte[fixedBuffer.remaining() + this.header.length];
        fixedBuffer.get(buffer, this.header.length, fixedBuffer.remaining());
        System.arraycopy(this.header, 0, buffer, 0, this.header.length);
        long ts = mediaFrame2.getInfo().getTimestamp() / (long)1000;
        Object object = callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.AUDIO), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void reset(boolean resetInfo) {
    }
}

