/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp.message;

import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.MessageType;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import com.pedro.rtmp.utils.CommandSessionHistory;
import com.pedro.rtmp.utils.UtilsKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\nJ\b\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/pedro/rtmp/rtmp/message/RtmpHeader;", "", "basicHeader", "Lcom/pedro/rtmp/rtmp/message/BasicHeader;", "<init>", "(Lcom/pedro/rtmp/rtmp/message/BasicHeader;)V", "getBasicHeader", "()Lcom/pedro/rtmp/rtmp/message/BasicHeader;", "setBasicHeader", "timeStamp", "", "getTimeStamp", "()I", "setTimeStamp", "(I)V", "messageLength", "getMessageLength", "setMessageLength", "messageType", "Lcom/pedro/rtmp/rtmp/message/MessageType;", "getMessageType", "()Lcom/pedro/rtmp/rtmp/message/MessageType;", "setMessageType", "(Lcom/pedro/rtmp/rtmp/message/MessageType;)V", "messageStreamId", "getMessageStreamId", "setMessageStreamId", "writeHeader", "", "output", "Ljava/io/OutputStream;", "getPacketLength", "toString", "", "Companion", "rtmp_release"})
public final class RtmpHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BasicHeader basicHeader;
    private int timeStamp;
    private int messageLength;
    @Nullable
    private MessageType messageType;
    private int messageStreamId;
    @NotNull
    private static final String TAG = "RtmpHeader";

    public RtmpHeader(@NotNull BasicHeader basicHeader) {
        Intrinsics.checkNotNullParameter((Object)basicHeader, (String)"basicHeader");
        this.basicHeader = basicHeader;
    }

    @NotNull
    public final BasicHeader getBasicHeader() {
        return this.basicHeader;
    }

    public final void setBasicHeader(@NotNull BasicHeader basicHeader) {
        Intrinsics.checkNotNullParameter((Object)basicHeader, (String)"<set-?>");
        this.basicHeader = basicHeader;
    }

    public final int getTimeStamp() {
        return this.timeStamp;
    }

    public final void setTimeStamp(int n) {
        this.timeStamp = n;
    }

    public final int getMessageLength() {
        return this.messageLength;
    }

    public final void setMessageLength(int n) {
        this.messageLength = n;
    }

    @Nullable
    public final MessageType getMessageType() {
        return this.messageType;
    }

    public final void setMessageType(@Nullable MessageType messageType) {
        this.messageType = messageType;
    }

    public final int getMessageStreamId() {
        return this.messageStreamId;
    }

    public final void setMessageStreamId(int n) {
        this.messageStreamId = n;
    }

    public final void writeHeader(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.writeHeader(this.basicHeader, output);
    }

    public final void writeHeader(@NotNull BasicHeader basicHeader, @NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)basicHeader, (String)"basicHeader");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.write(basicHeader.getChunkType().getMark() << 6 | basicHeader.getChunkStreamId());
        switch (WhenMappings.$EnumSwitchMapping$0[basicHeader.getChunkType().ordinal()]) {
            case 1: {
                UtilsKt.writeUInt24(output, Math.min(this.timeStamp, 0xFFFFFF));
                UtilsKt.writeUInt24(output, this.messageLength);
                MessageType messageType = this.messageType;
                if (messageType != null) {
                    MessageType messageType2 = messageType;
                    boolean bl = false;
                    output.write(messageType2.getMark());
                }
                UtilsKt.writeUInt32LittleEndian(output, this.messageStreamId);
                if (this.timeStamp <= 0xFFFFFF) break;
                UtilsKt.writeUInt32(output, this.timeStamp);
                break;
            }
            case 2: {
                UtilsKt.writeUInt24(output, Math.min(this.timeStamp, 0xFFFFFF));
                UtilsKt.writeUInt24(output, this.messageLength);
                MessageType messageType = this.messageType;
                if (messageType != null) {
                    MessageType messageType3 = messageType;
                    boolean bl = false;
                    output.write(messageType3.getMark());
                }
                if (this.timeStamp <= 0xFFFFFF) break;
                UtilsKt.writeUInt32(output, this.timeStamp);
                break;
            }
            case 3: {
                UtilsKt.writeUInt24(output, Math.min(this.timeStamp, 0xFFFFFF));
                if (this.timeStamp <= 0xFFFFFF) break;
                UtilsKt.writeUInt32(output, this.timeStamp);
                break;
            }
            case 4: {
                if (this.timeStamp <= 0xFFFFFF) break;
                UtilsKt.writeUInt32(output, this.timeStamp);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final int getPacketLength() {
        return this.messageLength + this.basicHeader.getHeaderSize(this.timeStamp);
    }

    @NotNull
    public String toString() {
        return "RtmpHeader(timeStamp=" + this.timeStamp + ", messageLength=" + this.messageLength + ", messageType=" + this.messageType + ", messageStreamId=" + this.messageStreamId + ", basicHeader=" + this.basicHeader + ")";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/pedro/rtmp/rtmp/message/RtmpHeader$Companion;", "", "<init>", "()V", "TAG", "", "readHeader", "Lcom/pedro/rtmp/rtmp/message/RtmpHeader;", "input", "Ljava/io/InputStream;", "commandSessionHistory", "Lcom/pedro/rtmp/utils/CommandSessionHistory;", "timestamp", "", "rtmp_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RtmpHeader readHeader(@NotNull InputStream input, @NotNull CommandSessionHistory commandSessionHistory, int timestamp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)commandSessionHistory, (String)"commandSessionHistory");
            BasicHeader basicHeader = BasicHeader.Companion.parseBasicHeader(input);
            int timeStamp = timestamp;
            int messageLength = 0;
            MessageType messageType = null;
            int messageStreamId = 0;
            RtmpHeader lastHeader = commandSessionHistory.getLastReadHeader(basicHeader.getChunkStreamId());
            switch (WhenMappings.$EnumSwitchMapping$0[basicHeader.getChunkType().ordinal()]) {
                case 1: {
                    timeStamp = UtilsKt.readUInt24(input);
                    messageLength = UtilsKt.readUInt24(input);
                    messageType = RtmpMessage.Companion.getMarkType(input.read());
                    messageStreamId = UtilsKt.readUInt32LittleEndian(input);
                    if (timeStamp < 0xFFFFFF) break;
                    timeStamp = UtilsKt.readUInt32(input);
                    break;
                }
                case 2: {
                    if (lastHeader != null) {
                        messageStreamId = lastHeader.getMessageStreamId();
                    }
                    timeStamp = UtilsKt.readUInt24(input);
                    messageLength = UtilsKt.readUInt24(input);
                    messageType = RtmpMessage.Companion.getMarkType(input.read());
                    if (timeStamp < 0xFFFFFF) break;
                    timeStamp = UtilsKt.readUInt32(input);
                    break;
                }
                case 3: {
                    if (lastHeader != null) {
                        messageLength = lastHeader.getMessageLength();
                        messageType = lastHeader.getMessageType();
                        messageStreamId = lastHeader.getMessageStreamId();
                    }
                    if ((timeStamp = UtilsKt.readUInt24(input)) < 0xFFFFFF) break;
                    timeStamp = UtilsKt.readUInt32(input);
                    break;
                }
                case 4: {
                    if (lastHeader != null) {
                        timeStamp = lastHeader.getTimeStamp();
                        messageLength = lastHeader.getMessageLength();
                        messageType = lastHeader.getMessageType();
                        messageStreamId = lastHeader.getMessageStreamId();
                    }
                    if (timeStamp < 0xFFFFFF) break;
                    timeStamp = UtilsKt.readUInt32(input);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            RtmpHeader rtmpHeader = new RtmpHeader(basicHeader);
            rtmpHeader.setTimeStamp(timeStamp);
            rtmpHeader.setMessageLength(messageLength);
            rtmpHeader.setMessageType(messageType);
            rtmpHeader.setMessageStreamId(messageStreamId);
            return rtmpHeader;
        }

        public static /* synthetic */ RtmpHeader readHeader$default(Companion companion, InputStream inputStream, CommandSessionHistory commandSessionHistory, int n, int n2, Object object) throws IOException {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.readHeader(inputStream, commandSessionHistory, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ChunkType.values().length];
                try {
                    nArray[ChunkType.TYPE_0.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChunkType.TYPE_1.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChunkType.TYPE_2.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChunkType.TYPE_3.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChunkType.values().length];
            try {
                nArray[ChunkType.TYPE_0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChunkType.TYPE_1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChunkType.TYPE_2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChunkType.TYPE_3.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

