/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.utils.socket;

import android.util.Log;
import com.pedro.common.TimeUtils;
import com.pedro.rtmp.utils.socket.RtmpSocket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010(\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020'H\u0002R\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/pedro/rtmp/utils/socket/TcpTunneledSocket;", "Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "host", "", "port", "", "secured", "", "(Ljava/lang/String;IZ)V", "TAG", "connected", "connectionId", "headers", "", "index", "Ljava/util/concurrent/atomic/AtomicLong;", "input", "Ljava/io/ByteArrayInputStream;", "maxStoredPackets", "output", "Ljava/io/ByteArrayOutputStream;", "storedPackets", "sync", "", "close", "", "configureSocket", "Ljava/net/HttpURLConnection;", "path", "connect", "flush", "isPacket", "getInputStream", "Ljava/io/InputStream;", "getOutStream", "Ljava/io/OutputStream;", "isConnected", "isReachable", "requestRead", "", "requestWrite", "data", "rtmp_release"})
@SourceDebugExtension(value={"SMAP\nTcpTunneledSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TcpTunneledSocket.kt\ncom/pedro/rtmp/utils/socket/TcpTunneledSocket\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,169:1\n215#2,2:170\n*S KotlinDebug\n*F\n+ 1 TcpTunneledSocket.kt\ncom/pedro/rtmp/utils/socket/TcpTunneledSocket\n*L\n161#1:170,2\n*E\n"})
public final class TcpTunneledSocket
extends RtmpSocket {
    @NotNull
    private final String host;
    private final int port;
    private final boolean secured;
    @NotNull
    private final String TAG;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private String connectionId;
    private boolean connected;
    @NotNull
    private AtomicLong index;
    @NotNull
    private ByteArrayOutputStream output;
    @NotNull
    private ByteArrayInputStream input;
    @NotNull
    private final Object sync;
    private int storedPackets;
    private final int maxStoredPackets;

    public TcpTunneledSocket(@NotNull String host, int port, boolean secured) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.secured = secured;
        this.TAG = "TcpTunneledSocket";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)"application/x-fcs"), TuplesKt.to((Object)"User-Agent", (Object)"Shockwave Flash")};
        this.headers = MapsKt.mapOf((Pair[])pairArray);
        this.connectionId = "";
        this.index = new AtomicLong(0L);
        this.output = new ByteArrayOutputStream();
        this.input = new ByteArrayInputStream(new byte[0]);
        this.sync = new Object();
        this.maxStoredPackets = 10;
    }

    @Override
    @NotNull
    public OutputStream getOutStream() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InputStream getInputStream() {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            long start2 = TimeUtils.getCurrentTimeMillis();
            while (this.input.available() <= 1 && this.connected) {
                long i = this.index.addAndGet(1L);
                byte[] bytes = this.requestRead("idle/" + this.connectionId + "/" + i, this.secured);
                this.input = new ByteArrayInputStream(bytes, 1, bytes.length);
                if (TimeUtils.getCurrentTimeMillis() - start2 < (long)this.getTimeout()) continue;
                throw new SocketTimeoutException("couldn't receive a valid packet");
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean isPacket) {
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            if (isPacket && this.storedPackets < this.maxStoredPackets) {
                int n = this.storedPackets;
                this.storedPackets = n + 1;
                return;
            }
            if (!this.connected) {
                return;
            }
            long i = this.index.addAndGet(1L);
            byte[] bytes = this.output.toByteArray();
            this.output.reset();
            String string = "send/" + this.connectionId + "/" + i;
            Intrinsics.checkNotNull((Object)bytes);
            this.requestWrite(string, this.secured, bytes);
            this.storedPackets = 0;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        Object object = this.sync;
        synchronized (object) {
            Object object2;
            boolean bl = false;
            try {
                object2 = new byte[]{0};
                this.requestWrite("fcs/ident2", this.secured, (byte[])object2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                byte[] openResult = this.requestRead("open/1", this.secured);
                this.connectionId = StringsKt.trimIndent((String)new String(openResult, Charsets.UTF_8));
                byte[] byArray = new byte[]{0};
                this.requestWrite("idle/" + this.connectionId + "/" + this.index.get(), this.secured, byArray);
                this.connected = true;
                object2 = Log.i((String)this.TAG, (String)"Connection success");
            }
            catch (IOException e) {
                Log.e((String)this.TAG, (String)("Connection failed: " + e.getMessage()));
                this.connected = false;
                object2 = Unit.INSTANCE;
            }
            Object object3 = object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Log.i((String)this.TAG, (String)"closing tunneled socket...");
        this.connected = false;
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            new Thread(() -> TcpTunneledSocket.close$lambda$4$lambda$3(this)).start();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isReachable() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void requestWrite(String path, boolean secured, byte[] data) throws IOException {
        HttpURLConnection socket = this.configureSocket(path, secured);
        try {
            boolean success;
            socket.connect();
            socket.getOutputStream().write(data);
            InputStream inputStream = socket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
            if (bytes.length > 1) {
                this.input = new ByteArrayInputStream(bytes, 1, bytes.length);
            }
            boolean bl = success = socket.getResponseCode() == 200;
            if (!success) {
                throw new IOException("send packet failed: " + socket.getResponseMessage());
            }
        }
        finally {
            socket.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] requestRead(String path, boolean secured) throws IOException {
        HttpURLConnection socket = this.configureSocket(path, secured);
        try {
            boolean success;
            socket.connect();
            InputStream inputStream = socket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            byte[] data = ByteStreamsKt.readBytes((InputStream)inputStream);
            boolean bl = success = socket.getResponseCode() == 200;
            if (!success) {
                throw new IOException("receive packet failed: " + socket.getResponseMessage());
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            socket.disconnect();
        }
    }

    private final HttpURLConnection configureSocket(String path, boolean secured) {
        HttpURLConnection httpURLConnection;
        String schema = secured ? "https" : "http";
        URL url = new URL(schema + "://" + this.host + ":" + this.port + "/" + path);
        if (secured) {
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            httpURLConnection = (HttpsURLConnection)uRLConnection;
        } else {
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        HttpURLConnection socket = httpURLConnection;
        Log.i((String)this.TAG, (String)("open: " + url));
        socket.setRequestMethod("POST");
        Map<String, String> $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            socket.addRequestProperty(key, value);
        }
        socket.setDoOutput(true);
        socket.setConnectTimeout(this.getTimeout());
        socket.setReadTimeout(this.getTimeout());
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void close$lambda$4$lambda$3(TcpTunneledSocket this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            byte[] byArray = new byte[]{0};
            this$0.requestWrite("close/" + this$0.connectionId, this$0.secured, byArray);
            Log.i((String)this$0.TAG, (String)"Close success");
        }
        catch (IOException e) {
            Log.e((String)this$0.TAG, (String)("Close request failed: " + e.getMessage()));
        }
        finally {
            this$0.index.set(0L);
            this$0.connectionId = "";
        }
    }
}

