/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.util.Log;
import com.pedro.rtmp.amf.v0.AmfEcmaArray;
import com.pedro.rtmp.amf.v0.AmfNull;
import com.pedro.rtmp.amf.v0.AmfObject;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.rtmp.CommandsManager;
import com.pedro.rtmp.rtmp.chunk.ChunkStreamId;
import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.command.CommandAmf0;
import com.pedro.rtmp.rtmp.message.data.DataAmf0;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/pedro/rtmp/rtmp/CommandsManagerAmf0;", "Lcom/pedro/rtmp/rtmp/CommandsManager;", "()V", "createStream", "", "output", "Ljava/io/OutputStream;", "sendClose", "sendConnect", "auth", "", "sendMetadata", "sendPublish", "rtmp_release"})
public final class CommandsManagerAmf0
extends CommandsManager {
    @Override
    public void sendConnect(@NotNull String auth, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 connect = new CommandAmf0("connect", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_CONNECTION.getMark()));
        AmfObject connectInfo = new AmfObject(null, 1, null);
        connectInfo.setProperty("app", this.getAppName() + auth);
        connectInfo.setProperty("flashVer", "FMLE/3.0 (compatible; Lavf57.56.101)");
        connectInfo.setProperty("swfUrl", "");
        connectInfo.setProperty("tcUrl", this.getTcUrl() + auth);
        connectInfo.setProperty("fpad", false);
        connectInfo.setProperty("capabilities", 239.0);
        if (!this.getAudioDisabled()) {
            connectInfo.setProperty("audioCodecs", 3191.0);
        }
        if (!this.getVideoDisabled()) {
            connectInfo.setProperty("videoCodecs", 252.0);
            connectInfo.setProperty("videoFunction", 1.0);
        }
        connectInfo.setProperty("pageUrl", "");
        connectInfo.setProperty("objectEncoding", 0.0);
        connect.addData(connectInfo);
        connect.writeHeader(output);
        connect.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "connect");
        Log.i((String)this.getTAG(), (String)("send " + connect));
    }

    @Override
    public void createStream(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 releaseStream = new CommandAmf0("releaseStream", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        releaseStream.addData(new AmfNull());
        releaseStream.addData(new AmfString(this.getStreamName()));
        releaseStream.writeHeader(output);
        releaseStream.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "releaseStream");
        Log.i((String)this.getTAG(), (String)("send " + releaseStream));
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 fcPublish = new CommandAmf0("FCPublish", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        fcPublish.addData(new AmfNull());
        fcPublish.addData(new AmfString(this.getStreamName()));
        fcPublish.writeHeader(output);
        fcPublish.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "FCPublish");
        Log.i((String)this.getTAG(), (String)("send " + fcPublish));
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 createStream = new CommandAmf0("createStream", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_CONNECTION.getMark()));
        createStream.addData(new AmfNull());
        createStream.writeHeader(output);
        createStream.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "createStream");
        Log.i((String)this.getTAG(), (String)("send " + createStream));
    }

    @Override
    public void sendMetadata(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "@setDataFrame";
        DataAmf0 metadata = new DataAmf0(name, this.getCurrentTimestamp(), this.getStreamId(), null, 8, null);
        metadata.addData(new AmfString("onMetaData"));
        AmfEcmaArray amfEcmaArray = new AmfEcmaArray(null, 1, null);
        amfEcmaArray.setProperty("duration", 0.0);
        if (!this.getVideoDisabled()) {
            amfEcmaArray.setProperty("width", this.getWidth());
            amfEcmaArray.setProperty("height", this.getHeight());
            amfEcmaArray.setProperty("videocodecid", 7.0);
            amfEcmaArray.setProperty("framerate", this.getFps());
            amfEcmaArray.setProperty("videodatarate", 0.0);
        }
        if (!this.getAudioDisabled()) {
            amfEcmaArray.setProperty("audiocodecid", 10.0);
            amfEcmaArray.setProperty("audiosamplerate", this.getSampleRate());
            amfEcmaArray.setProperty("audiosamplesize", 16.0);
            amfEcmaArray.setProperty("audiodatarate", 0.0);
            amfEcmaArray.setProperty("stereo", this.isStereo());
        }
        amfEcmaArray.setProperty("filesize", 0.0);
        metadata.addData(amfEcmaArray);
        metadata.writeHeader(output);
        metadata.writeBody(output);
        Log.i((String)this.getTAG(), (String)("send " + metadata));
    }

    @Override
    public void sendPublish(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "publish";
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 publish = new CommandAmf0(name, this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        publish.addData(new AmfNull());
        publish.addData(new AmfString(this.getStreamName()));
        publish.addData(new AmfString("live"));
        publish.writeHeader(output);
        publish.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), name);
        Log.i((String)this.getTAG(), (String)("send " + publish));
    }

    @Override
    public void sendClose(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "closeStream";
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 closeStream = new CommandAmf0(name, this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        closeStream.addData(new AmfNull());
        closeStream.writeHeader(output);
        closeStream.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), name);
        Log.i((String)this.getTAG(), (String)("send " + closeStream));
    }
}

