/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.audio;

import android.media.MediaCodec;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.audio.AudioFormat;
import com.pedro.rtmp.flv.audio.AudioObjectType;
import com.pedro.rtmp.flv.audio.AudioPacketCallback;
import com.pedro.rtmp.flv.audio.AudioSize;
import com.pedro.rtmp.flv.audio.AudioSoundRate;
import com.pedro.rtmp.flv.audio.AudioSoundType;
import com.pedro.rtmp.flv.audio.AudioSpecificConfig;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0011J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pedro/rtmp/flv/audio/AacPacket;", "", "audioPacketCallback", "Lcom/pedro/rtmp/flv/audio/AudioPacketCallback;", "(Lcom/pedro/rtmp/flv/audio/AudioPacketCallback;)V", "audioSize", "Lcom/pedro/rtmp/flv/audio/AudioSize;", "configSend", "", "header", "", "isStereo", "objectType", "Lcom/pedro/rtmp/flv/audio/AudioObjectType;", "sampleRate", "", "createFlvAudioPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "reset", "sendAudioInfo", "Type", "rtmp_release"})
public final class AacPacket {
    @NotNull
    private final AudioPacketCallback audioPacketCallback;
    @NotNull
    private final byte[] header;
    private boolean configSend;
    private int sampleRate;
    private boolean isStereo;
    @NotNull
    private AudioSize audioSize;
    @NotNull
    private final AudioObjectType objectType;

    public AacPacket(@NotNull AudioPacketCallback audioPacketCallback) {
        Intrinsics.checkNotNullParameter((Object)audioPacketCallback, (String)"audioPacketCallback");
        this.audioPacketCallback = audioPacketCallback;
        this.header = new byte[2];
        this.sampleRate = 44100;
        this.isStereo = true;
        this.audioSize = AudioSize.SND_16_BIT;
        this.objectType = AudioObjectType.AAC_LC;
    }

    public final void sendAudioInfo(int sampleRate, boolean isStereo, @NotNull AudioSize audioSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioSize), (String)"audioSize");
        this.sampleRate = sampleRate;
        this.isStereo = isStereo;
        this.audioSize = audioSize;
    }

    public static /* synthetic */ void sendAudioInfo$default(AacPacket aacPacket, int n, boolean bl, AudioSize audioSize, int n2, Object object) {
        if ((n2 & 4) != 0) {
            audioSize = AudioSize.SND_16_BIT;
        }
        aacPacket.sendAudioInfo(n, bl, audioSize);
    }

    public final void createFlvAudioPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo info) {
        AudioSoundRate audioSoundRate;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.header[0] = this.isStereo ? AudioSoundType.STEREO.getValue() : AudioSoundType.MONO.getValue();
        this.header[0] = (byte)(this.header[0] | (byte)(this.audioSize.getValue() << 1));
        switch (this.sampleRate) {
            case 44100: {
                audioSoundRate = AudioSoundRate.SR_44_1K;
                break;
            }
            case 22050: {
                audioSoundRate = AudioSoundRate.SR_22K;
                break;
            }
            case 11025: {
                audioSoundRate = AudioSoundRate.SR_11K;
                break;
            }
            case 5500: {
                audioSoundRate = AudioSoundRate.SR_5_5K;
                break;
            }
            default: {
                audioSoundRate = AudioSoundRate.SR_44_1K;
            }
        }
        AudioSoundRate soundRate = audioSoundRate;
        this.header[0] = (byte)(this.header[0] | (byte)(soundRate.getValue() << 2));
        this.header[0] = (byte)(this.header[0] | (byte)(AudioFormat.AAC.getValue() << 4));
        byte[] buffer = null;
        if (!this.configSend) {
            AudioSpecificConfig config = new AudioSpecificConfig(this.objectType.getValue(), this.sampleRate, this.isStereo ? 2 : 1);
            buffer = new byte[config.getSize() + this.header.length];
            this.header[1] = Type.SEQUENCE.getMark();
            config.write(buffer, this.header.length);
            this.configSend = true;
        } else {
            this.header[1] = Type.RAW.getMark();
            buffer = new byte[info.size - info.offset + this.header.length];
            byteBuffer.get(buffer, this.header.length, info.size - info.offset);
        }
        System.arraycopy(this.header, 0, buffer, 0, this.header.length);
        long ts = info.presentationTimeUs / (long)1000;
        this.audioPacketCallback.onAudioFrameCreated(new FlvPacket(buffer, ts, buffer.length, FlvType.AUDIO));
    }

    public final void reset() {
        this.configSend = false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/pedro/rtmp/flv/audio/AacPacket$Type;", "", "mark", "", "(Ljava/lang/String;IB)V", "getMark", "()B", "SEQUENCE", "RAW", "rtmp_release"})
    public static final class Type
    extends Enum<Type> {
        private final byte mark;
        public static final /* enum */ Type SEQUENCE = new Type(0);
        public static final /* enum */ Type RAW = new Type(1);
        private static final /* synthetic */ Type[] $VALUES;

        private Type(byte mark) {
            this.mark = mark;
        }

        public final byte getMark() {
            return this.mark;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.SEQUENCE, Type.RAW};
        }
    }
}

