/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.packets;

import com.github.faucamp.simplertmp.amf.AmfString;
import com.github.faucamp.simplertmp.packets.RtmpHeader;
import com.github.faucamp.simplertmp.packets.VariableBodyRtmpPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Data
extends VariableBodyRtmpPacket {
    private String type;

    public Data(RtmpHeader header) {
        super(header);
    }

    public Data(String type) {
        super(new RtmpHeader(RtmpHeader.ChunkType.TYPE_0_FULL, 3, RtmpHeader.MessageType.DATA_AMF0));
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void readBody(InputStream in) throws IOException {
        this.type = AmfString.readStringFrom(in, false);
        int bytesRead = AmfString.sizeOf(this.type, false);
        this.readVariableData(in, bytesRead);
    }

    @Override
    protected void writeBody(OutputStream out) throws IOException {
        AmfString.writeStringTo(out, this.type, false);
        this.writeVariableData(out);
    }

    @Override
    protected byte[] array() {
        return null;
    }

    @Override
    protected int size() {
        return 0;
    }
}

