/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.amf;

import java.util.HashMap;
import java.util.Map;

public enum AmfType {
    NUMBER(0),
    BOOLEAN(1),
    STRING(2),
    OBJECT(3),
    NULL(5),
    UNDEFINED(6),
    ECMA_MAP(8),
    STRICT_ARRAY(10);

    private byte value;
    private static final Map<Byte, AmfType> quickLookupMap;

    private AmfType(int intValue) {
        this.value = (byte)intValue;
    }

    public byte getValue() {
        return this.value;
    }

    public static AmfType valueOf(byte amfTypeByte) {
        return quickLookupMap.get(amfTypeByte);
    }

    static {
        quickLookupMap = new HashMap<Byte, AmfType>();
        for (AmfType amfType : AmfType.values()) {
            quickLookupMap.put(amfType.getValue(), amfType);
        }
    }
}

