/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceView;
import java.util.Arrays;

@RequiresApi(api=21)
public class Camera2ApiManager
extends CameraDevice.StateCallback {
    private final String TAG = "Camera2ApiManager";
    private CameraDevice cameraDevice;
    private SurfaceView surfaceView;
    private Surface surface;
    private CameraManager cameraManager;
    private Handler cameraHandler;

    public Camera2ApiManager(SurfaceView surfaceView, Surface surface, Context context) {
        this.surfaceView = surfaceView;
        this.surface = surface;
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    private void startPreview(CameraDevice cameraDevice) {
        try {
            cameraDevice.createCaptureSession(Arrays.asList(this.surfaceView.getHolder().getSurface(), this.surface), new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    try {
                        cameraCaptureSession.setRepeatingBurst(Arrays.asList(Camera2ApiManager.this.drawPreview(Camera2ApiManager.this.surfaceView), Camera2ApiManager.this.drawInputSurface(Camera2ApiManager.this.surface)), null, Camera2ApiManager.this.cameraHandler);
                        Log.i((String)"Camera2ApiManager", (String)"camera configured");
                    }
                    catch (CameraAccessException e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    cameraCaptureSession.close();
                    Log.e((String)"Camera2ApiManager", (String)"configuration failed");
                }
            }, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private CaptureRequest drawPreview(SurfaceView surfaceView) {
        try {
            CaptureRequest.Builder captureRequestBuilder = this.cameraDevice.createCaptureRequest(1);
            captureRequestBuilder.addTarget(surfaceView.getHolder().getSurface());
            captureRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            return captureRequestBuilder.build();
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private CaptureRequest drawInputSurface(Surface surface) {
        try {
            CaptureRequest.Builder builder = this.cameraDevice.createCaptureRequest(1);
            builder.addTarget(surface);
            return builder.build();
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)e.getMessage());
            return null;
        }
    }

    public void openCamera() {
        this.openCameraId(0);
    }

    public void openCameraId(Integer cameraId) {
        HandlerThread cameraHandlerThread = new HandlerThread("Camera2ApiManager Id = " + cameraId);
        cameraHandlerThread.start();
        this.cameraHandler = new Handler(cameraHandlerThread.getLooper());
        try {
            this.cameraManager.openCamera(cameraId.toString(), (CameraDevice.StateCallback)this, this.cameraHandler);
        }
        catch (CameraAccessException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public void openCameraFront() {
        try {
            if ((Integer)this.cameraManager.getCameraCharacteristics("0").get(CameraCharacteristics.LENS_FACING) == 0) {
                this.openCameraId(0);
            } else {
                this.openCameraId(1);
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public void openCameraBack() {
        try {
            if ((Integer)this.cameraManager.getCameraCharacteristics("0").get(CameraCharacteristics.LENS_FACING) == 1) {
                this.openCameraId(0);
            } else {
                this.openCameraId(1);
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public void switchCamera() {
        if (this.cameraDevice != null) {
            int cameraId = Integer.parseInt(this.cameraDevice.getId()) == 1 ? 0 : 1;
            this.closeCamera();
            this.openCameraId(cameraId);
        }
    }

    public void closeCamera() {
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        this.cameraHandler.getLooper().quitSafely();
    }

    public void onOpened(@NonNull CameraDevice cameraDevice) {
        this.cameraDevice = cameraDevice;
        this.startPreview(cameraDevice);
        Log.i((String)"Camera2ApiManager", (String)"camera opened");
    }

    public void onDisconnected(@NonNull CameraDevice cameraDevice) {
        cameraDevice.close();
        Log.i((String)"Camera2ApiManager", (String)"camera disconnected");
    }

    public void onError(@NonNull CameraDevice cameraDevice, int i) {
        cameraDevice.close();
        Log.e((String)"Camera2ApiManager", (String)"open failed");
    }
}

