/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.hardware.Camera;
import android.opengl.GLES20;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.EffectManager;
import com.pedro.encoder.input.video.FpsController;
import com.pedro.encoder.input.video.GetCameraData;
import java.io.IOException;
import java.util.List;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class Camera1ApiManager
implements Camera.PreviewCallback {
    private String TAG = "Camera1ApiManager";
    private Camera camera = null;
    private SurfaceView surfaceView;
    private GetCameraData getCameraData;
    private boolean running = false;
    private boolean lanternEnable = false;
    private int cameraSelect;
    private int width = 1280;
    private int height = 720;
    private int fps = 30;
    private int orientation = 0;
    private int imageFormat = 17;
    private FpsController fpsController;

    public Camera1ApiManager(SurfaceView surfaceView, GetCameraData getCameraData) {
        this.surfaceView = surfaceView;
        this.getCameraData = getCameraData;
        if (surfaceView.getContext().getResources().getConfiguration().orientation == 1) {
            this.orientation = 90;
        }
        this.cameraSelect = this.selectCamera();
    }

    public void prepareCamera(int width, int height, int fps, int imageFormat) {
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.imageFormat = imageFormat;
    }

    public void prepareCamera() {
        this.prepareCamera(this.width, this.height, this.fps, this.imageFormat);
    }

    public void start() {
        if (this.camera == null) {
            try {
                this.camera = Camera.open((int)this.cameraSelect);
                if (!this.checkCanOpen()) {
                    throw new CameraOpenException("This camera resolution cant be opened");
                }
                Camera.Parameters parameters = this.camera.getParameters();
                parameters.setPreviewSize(this.width, this.height);
                parameters.setPreviewFormat(this.imageFormat);
                int[] range = this.adaptFpsRange(this.fps, parameters.getSupportedPreviewFpsRange());
                parameters.setPreviewFpsRange(range[0], range[1]);
                this.camera.setParameters(parameters);
                this.camera.setDisplayOrientation(this.orientation);
                this.camera.setPreviewDisplay(this.surfaceView.getHolder());
                this.camera.setPreviewCallback((Camera.PreviewCallback)this);
                this.camera.startPreview();
                this.running = true;
                this.fpsController = new FpsController(this.fps, this.camera);
                Log.i((String)this.TAG, (String)(this.width + "X" + this.height));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int selectCamera() {
        int number = Camera.getNumberOfCameras();
        int i = 0;
        while (i < number) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing == 0) {
                return i;
            }
            this.cameraSelect = i++;
        }
        return this.cameraSelect;
    }

    public void stop() {
        if (this.camera != null) {
            this.camera.setPreviewCallback(null);
            this.camera.stopPreview();
            this.camera.release();
            this.camera = null;
            this.clearSurface(this.surfaceView.getHolder());
            this.running = false;
        }
    }

    private void clearSurface(SurfaceHolder texture) {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        egl.eglInitialize(display, null);
        int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344, 0, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        egl.eglChooseConfig(display, attribList, configs, configs.length, numConfigs);
        EGLConfig config = configs[0];
        EGLContext context = egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, new int[]{12440, 2, 12344});
        EGLSurface eglSurface = egl.eglCreateWindowSurface(display, config, (Object)texture, new int[]{12344});
        egl.eglMakeCurrent(display, eglSurface, eglSurface, context);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        egl.eglSwapBuffers(display, eglSurface);
        egl.eglDestroySurface(display, eglSurface);
        egl.eglMakeCurrent(display, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        egl.eglDestroyContext(display, context);
        egl.eglTerminate(display);
    }

    public boolean isRunning() {
        return this.running;
    }

    private int[] adaptFpsRange(int expectedFps, List<int[]> fpsRanges) {
        int[] closestRange = fpsRanges.get(0);
        int measure = Math.abs(closestRange[0] - (expectedFps *= 1000)) + Math.abs(closestRange[1] - expectedFps);
        for (int[] range : fpsRanges) {
            int curMeasure;
            if (range[0] > expectedFps || range[1] < expectedFps || (curMeasure = Math.abs(range[0] - expectedFps) + Math.abs(range[1] - expectedFps)) >= measure) continue;
            closestRange = range;
            measure = curMeasure;
        }
        return closestRange;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.fpsController.fpsIsValid()) {
            if (this.imageFormat == 842094169) {
                this.getCameraData.inputYv12Data(data);
            } else if (this.imageFormat == 17) {
                this.getCameraData.inputNv21Data(data);
            }
        }
    }

    public List<Integer> getCameraPreviewImageFormatSupported() {
        if (this.camera != null) {
            List formats = this.camera.getParameters().getSupportedPreviewFormats();
            for (Integer i : formats) {
                Log.i((String)this.TAG, (String)("camera format supported: " + i));
            }
            return formats;
        }
        return null;
    }

    public List<Camera.Size> getPreviewSize() {
        if (this.camera != null) {
            List previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
            for (Camera.Size size : previewSizes) {
                Log.i((String)this.TAG, (String)(size.width + "X" + size.height));
            }
            return previewSizes;
        }
        this.camera = Camera.open((int)this.cameraSelect);
        List previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
        this.camera.release();
        this.camera = null;
        for (Camera.Size size : previewSizes) {
            Log.i((String)this.TAG, (String)(size.width + "X" + size.height));
        }
        return previewSizes;
    }

    public void setEffect(EffectManager effect) {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setColorEffect(effect.getEffect());
            try {
                this.camera.setParameters(parameters);
            }
            catch (RuntimeException e) {
                Log.e((String)this.TAG, (String)"Unsupported effect");
                e.printStackTrace();
            }
        }
    }

    public void switchCamera() throws CameraOpenException {
        if (this.camera != null) {
            int number = Camera.getNumberOfCameras();
            for (int i = 0; i < number; ++i) {
                if (this.cameraSelect == i) continue;
                this.cameraSelect = i;
                this.stop();
                this.start();
                return;
            }
        }
    }

    private boolean checkCanOpen() {
        for (Camera.Size size : this.getPreviewSize()) {
            if (size.width != this.width || size.height != this.height) continue;
            return true;
        }
        return false;
    }

    public boolean isLanternEnable() {
        return this.lanternEnable;
    }

    public void enableLantern() {
        Camera.Parameters parameters = this.camera.getParameters();
        parameters.setFlashMode("torch");
        try {
            this.camera.setParameters(parameters);
            this.lanternEnable = true;
        }
        catch (RuntimeException e) {
            Log.e((String)this.TAG, (String)"lantern unsupported");
            e.printStackTrace();
        }
    }

    public void disableLantern() {
        Camera.Parameters parameters = this.camera.getParameters();
        parameters.setFlashMode("auto");
        try {
            this.camera.setParameters(parameters);
            this.lanternEnable = false;
        }
        catch (RuntimeException e) {
            Log.e((String)this.TAG, (String)"lantern unsupported");
            e.printStackTrace();
        }
    }
}

