/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.audio;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.pedro.encoder.audio.GetAccData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AudioEncoder
implements GetMicrophoneData {
    private String TAG = "AudioEncoder";
    private MediaCodec audioEncoder;
    private GetAccData getAccData;
    private MediaCodec.BufferInfo audioInfo = new MediaCodec.BufferInfo();
    private long mPresentTimeUs;
    private boolean running;
    private String mime = "audio/mp4a-latm";
    private int bitRate = 131072;
    private int sampleRate = 44100;
    private boolean isStereo = true;

    public AudioEncoder(GetAccData getAccData) {
        this.getAccData = getAccData;
    }

    public boolean prepareAudioEncoder(int bitRate, int sampleRate, boolean isStereo) {
        this.sampleRate = sampleRate;
        try {
            this.audioEncoder = MediaCodec.createEncoderByType((String)this.mime);
            int a = isStereo ? 2 : 1;
            MediaFormat audioFormat = MediaFormat.createAudioFormat((String)this.mime, (int)sampleRate, (int)a);
            audioFormat.setInteger("bitrate", bitRate);
            audioFormat.setInteger("max-input-size", 0);
            this.audioEncoder.configure(audioFormat, null, null, 1);
            this.running = false;
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean prepareAudioEncoder() {
        return this.prepareAudioEncoder(this.bitRate, this.sampleRate, this.isStereo);
    }

    public void start() {
        this.mPresentTimeUs = System.nanoTime() / 1000L;
        this.audioEncoder.start();
        this.running = true;
        Log.i((String)this.TAG, (String)"AudioEncoder started");
    }

    public void stop() {
        if (this.audioEncoder != null) {
            this.audioEncoder.stop();
            this.audioEncoder.release();
            this.audioEncoder = null;
        }
        this.running = false;
        Log.i((String)this.TAG, (String)"AudioEncoder stopped");
    }

    @Override
    public void inputPcmData(byte[] buffer, int size) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getDataFromEncoderAPI21(buffer, size);
        } else {
            this.getDataFromEncoder(buffer, size);
        }
    }

    @RequiresApi(api=21)
    private void getDataFromEncoderAPI21(byte[] data, int size) {
        int outBufferIndex;
        int inBufferIndex = this.audioEncoder.dequeueInputBuffer(-1L);
        if (inBufferIndex >= 0) {
            ByteBuffer bb = this.audioEncoder.getInputBuffer(inBufferIndex);
            bb.put(data, 0, size);
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            this.audioEncoder.queueInputBuffer(inBufferIndex, 0, size, pts, 0);
        }
        while ((outBufferIndex = this.audioEncoder.dequeueOutputBuffer(this.audioInfo, 0L)) >= 0) {
            ByteBuffer bb = this.audioEncoder.getOutputBuffer(outBufferIndex);
            this.getAccData.getAccData(bb, this.audioInfo);
            this.audioEncoder.releaseOutputBuffer(outBufferIndex, false);
        }
    }

    private void getDataFromEncoder(byte[] data, int size) {
        int outBufferIndex;
        ByteBuffer[] inputBuffers = this.audioEncoder.getInputBuffers();
        ByteBuffer[] outputBuffers = this.audioEncoder.getOutputBuffers();
        int inBufferIndex = this.audioEncoder.dequeueInputBuffer(-1L);
        if (inBufferIndex >= 0) {
            ByteBuffer bb = inputBuffers[inBufferIndex];
            bb.clear();
            bb.put(data, 0, size);
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            this.audioEncoder.queueInputBuffer(inBufferIndex, 0, size, pts, 0);
        }
        while ((outBufferIndex = this.audioEncoder.dequeueOutputBuffer(this.audioInfo, 0L)) >= 0) {
            ByteBuffer bb = outputBuffers[outBufferIndex];
            this.getAccData.getAccData(bb, this.audioInfo);
            this.audioEncoder.releaseOutputBuffer(outBufferIndex, false);
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

