/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.sources.audio;

import android.media.AudioDeviceInfo;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.sources.audio.AudioSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0014J\u0012\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u0017J\u0006\u0010 \u001a\u00020\u0017J\u0006\u0010!\u001a\u00020\u000fJ\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lcom/pedro/encoder/input/sources/audio/MicrophoneSource;", "Lcom/pedro/encoder/input/sources/audio/AudioSource;", "Lcom/pedro/encoder/input/audio/GetMicrophoneData;", "audioSource", "", "<init>", "(I)V", "getAudioSource", "()I", "setAudioSource", "microphone", "Lcom/pedro/encoder/input/audio/MicrophoneManager;", "preferredDevice", "Landroid/media/AudioDeviceInfo;", "create", "", "sampleRate", "isStereo", "echoCanceler", "noiseSuppressor", "setPreferredDevice", "deviceInfo", "start", "", "getMicrophoneData", "stop", "isRunning", "release", "inputPCMData", "frame", "Lcom/pedro/encoder/Frame;", "mute", "unMute", "isMuted", "setAudioEffect", "effect", "Lcom/pedro/encoder/input/audio/CustomAudioEffect;", "value", "", "microphoneVolume", "getMicrophoneVolume", "()F", "setMicrophoneVolume", "(F)V", "encoder_release"})
public final class MicrophoneSource
extends AudioSource
implements GetMicrophoneData {
    private int audioSource;
    @NotNull
    private final MicrophoneManager microphone;
    @Nullable
    private AudioDeviceInfo preferredDevice;

    public MicrophoneSource(int audioSource) {
        this.audioSource = audioSource;
        this.microphone = new MicrophoneManager(this);
    }

    public /* synthetic */ MicrophoneSource(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public final int getAudioSource() {
        return this.audioSource;
    }

    public final void setAudioSource(int n) {
        this.audioSource = n;
    }

    @Override
    protected boolean create(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        boolean result = this.microphone.createMicrophone(this.audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor);
        if (!result) {
            throw new IllegalArgumentException("Some parameters specified are not valid");
        }
        return true;
    }

    @RequiresApi(api=23)
    public final boolean setPreferredDevice(@Nullable AudioDeviceInfo deviceInfo) {
        this.preferredDevice = deviceInfo;
        return this.microphone.setPreferredDevice(deviceInfo);
    }

    @Override
    public void start(@NotNull GetMicrophoneData getMicrophoneData) {
        Intrinsics.checkNotNullParameter((Object)getMicrophoneData, (String)"getMicrophoneData");
        this.setGetMicrophoneData(getMicrophoneData);
        if (!this.isRunning()) {
            boolean result = this.microphone.createMicrophone(this.audioSource, this.getSampleRate(), this.isStereo(), this.getEchoCanceler(), this.getNoiseSuppressor());
            if (!result) {
                throw new IllegalArgumentException("Failed to create microphone audio source");
            }
            if (Build.VERSION.SDK_INT >= 23) {
                this.microphone.setPreferredDevice(this.preferredDevice);
            }
            this.microphone.start();
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.setGetMicrophoneData(null);
            this.microphone.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.microphone.isRunning();
    }

    @Override
    public void release() {
    }

    @Override
    public void inputPCMData(@NotNull Frame frame) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            GetMicrophoneData getMicrophoneData = this.getGetMicrophoneData();
            if (getMicrophoneData == null) break block0;
            getMicrophoneData.inputPCMData(frame);
        }
    }

    public final void mute() {
        this.microphone.mute();
    }

    public final void unMute() {
        this.microphone.unMute();
    }

    public final boolean isMuted() {
        return this.microphone.isMuted();
    }

    public final void setAudioEffect(@NotNull CustomAudioEffect effect) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        this.microphone.setCustomAudioEffect(effect);
    }

    public final float getMicrophoneVolume() {
        return this.microphone.getMicrophoneVolume();
    }

    public final void setMicrophoneVolume(float value) {
        this.microphone.setMicrophoneVolume(value);
    }

    public MicrophoneSource() {
        this(0, 1, null);
    }
}

