/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.sources.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.sources.MediaProjectionHandler;
import com.pedro.encoder.input.sources.video.VideoSource;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J(\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0014J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pedro/encoder/input/sources/video/ScreenSource;", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "context", "Landroid/content/Context;", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaProjectionCallback", "Landroid/media/projection/MediaProjection$Callback;", "virtualDisplayCallback", "Landroid/hardware/display/VirtualDisplay$Callback;", "(Landroid/content/Context;Landroid/media/projection/MediaProjection;Landroid/media/projection/MediaProjection$Callback;Landroid/hardware/display/VirtualDisplay$Callback;)V", "TAG", "", "dpi", "", "handlerThread", "Landroid/os/HandlerThread;", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "checkResolutionSupported", "", "width", "height", "create", "fps", "rotation", "isRunning", "release", "", "resize", "start", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "encoder_release"})
@RequiresApi(value=21)
public final class ScreenSource
extends VideoSource {
    @NotNull
    private final String TAG;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @NotNull
    private HandlerThread handlerThread;
    @NotNull
    private final MediaProjection.Callback mediaProjectionCallback;
    @NotNull
    private final VirtualDisplay.Callback virtualDisplayCallback;
    private final int dpi;

    @JvmOverloads
    public ScreenSource(@NotNull Context context, @NotNull MediaProjection mediaProjection, @Nullable MediaProjection.Callback mediaProjectionCallback2, @Nullable VirtualDisplay.Callback virtualDisplayCallback2) {
        VirtualDisplay.Callback callback2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this.TAG = "ScreenSource";
        this.handlerThread = new HandlerThread(this.TAG);
        MediaProjection.Callback callback3 = mediaProjectionCallback2;
        if (callback3 == null) {
            callback3 = this.mediaProjectionCallback = (MediaProjection.Callback)new MediaProjection.Callback(){};
        }
        if ((callback2 = virtualDisplayCallback2) == null) {
            callback2 = new VirtualDisplay.Callback(){};
        }
        this.virtualDisplayCallback = callback2;
        this.dpi = context.getResources().getDisplayMetrics().densityDpi;
        MediaProjectionHandler.INSTANCE.setMediaProjection(mediaProjection);
    }

    public /* synthetic */ ScreenSource(Context context, MediaProjection mediaProjection, MediaProjection.Callback callback2, VirtualDisplay.Callback callback3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            callback2 = null;
        }
        if ((n & 8) != 0) {
            callback3 = null;
        }
        this(context, mediaProjection, callback2, callback3);
    }

    @Override
    protected boolean create(int width, int height, int fps, int rotation) {
        return this.checkResolutionSupported(width, height);
    }

    @Override
    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.setSurfaceTexture(surfaceTexture);
        if (!this.isRunning()) {
            int displayHeight;
            int flags = 16;
            boolean shouldRotate = this.getRotation() == 90 || this.getRotation() == 270;
            int displayWidth = shouldRotate ? this.getHeight() : this.getWidth();
            int n = displayHeight = shouldRotate ? this.getWidth() : this.getHeight();
            if (shouldRotate) {
                surfaceTexture.setDefaultBufferSize(this.getHeight(), this.getWidth());
            }
            this.handlerThread = new HandlerThread(this.TAG);
            this.handlerThread.start();
            MediaProjection mediaProjection = MediaProjectionHandler.INSTANCE.getMediaProjection();
            if (mediaProjection != null) {
                mediaProjection.registerCallback(this.mediaProjectionCallback, new Handler(this.handlerThread.getLooper()));
            }
            MediaProjection mediaProjection2 = MediaProjectionHandler.INSTANCE.getMediaProjection();
            VirtualDisplay virtualDisplay = this.virtualDisplay = mediaProjection2 != null ? mediaProjection2.createVirtualDisplay(this.TAG, displayWidth, displayHeight, this.dpi, flags, new Surface(surfaceTexture), this.virtualDisplayCallback, new Handler(this.handlerThread.getLooper())) : null;
            if (this.virtualDisplay == null) {
                throw new IllegalArgumentException("Failed to create internal virtual display");
            }
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            VirtualDisplay virtualDisplay = this.virtualDisplay;
            if (virtualDisplay != null) {
                virtualDisplay.release();
            }
            this.virtualDisplay = null;
            this.handlerThread.quitSafely();
        }
    }

    @Override
    public void release() {
        block0: {
            MediaProjection mediaProjection = MediaProjectionHandler.INSTANCE.getMediaProjection();
            if (mediaProjection == null) break block0;
            mediaProjection.unregisterCallback(this.mediaProjectionCallback);
        }
    }

    @Override
    public boolean isRunning() {
        return this.virtualDisplay != null;
    }

    private final boolean checkResolutionSupported(int width, int height) {
        if (width % 2 != 0 || height % 2 != 0) {
            throw new IllegalArgumentException("width and height values must be divisible by 2");
        }
        return true;
    }

    public final void resize(int width, int height) {
        block0: {
            VirtualDisplay virtualDisplay = this.virtualDisplay;
            if (virtualDisplay == null) break block0;
            virtualDisplay.resize(width, height, this.dpi);
        }
    }

    @JvmOverloads
    public ScreenSource(@NotNull Context context, @NotNull MediaProjection mediaProjection, @Nullable MediaProjection.Callback mediaProjectionCallback2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this(context, mediaProjection, mediaProjectionCallback2, null, 8, null);
    }

    @JvmOverloads
    public ScreenSource(@NotNull Context context, @NotNull MediaProjection mediaProjection) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this(context, mediaProjection, null, null, 12, null);
    }
}

