/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.sources.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.view.Surface;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoder;
import com.pedro.encoder.input.sources.OrientationForced;
import com.pedro.encoder.input.sources.video.VideoFileSource;
import com.pedro.encoder.input.sources.video.VideoSource;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0010\u0018\u00002\u00020\u0001BD\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0014J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\u001eJ\b\u0010\"\u001a\u00020\u0007H\u0016J\u000e\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u001eJ\b\u0010%\u001a\u00020\rH\u0016J\u0016\u0010&\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0005J\u000e\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u0007J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/pedro/encoder/input/sources/video/VideoFileSource;", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "context", "Landroid/content/Context;", "path", "Landroid/net/Uri;", "loopMode", "", "onFinish", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "isLoop", "", "(Landroid/content/Context;Landroid/net/Uri;ZLkotlin/jvm/functions/Function1;)V", "decoderInterface", "com/pedro/encoder/input/sources/video/VideoFileSource$decoderInterface$1", "Lcom/pedro/encoder/input/sources/video/VideoFileSource$decoderInterface$1;", "running", "videoDecoder", "Lcom/pedro/encoder/input/decoder/VideoDecoder;", "videoDecoderInterface", "Lkotlin/Function0;", "create", "width", "", "height", "fps", "rotation", "getDuration", "", "getOrientationConfig", "Lcom/pedro/encoder/input/sources/OrientationForced;", "getTime", "isRunning", "moveTo", "time", "release", "replaceFile", "uri", "setLoopMode", "enabled", "start", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "encoder_release"})
public final class VideoFileSource
extends VideoSource {
    @NotNull
    private final Context context;
    @NotNull
    private final Uri path;
    @NotNull
    private final Function0<Unit> videoDecoderInterface;
    @NotNull
    private final decoderInterface.1 decoderInterface;
    private boolean running;
    @NotNull
    private VideoDecoder videoDecoder;

    public VideoFileSource(@NotNull Context context, @NotNull Uri path, boolean loopMode, @NotNull Function1<? super Boolean, Unit> onFinish) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        this.context = context;
        this.path = path;
        this.videoDecoderInterface = (Function0)new Function0<Unit>(onFinish){
            final /* synthetic */ Function1<Boolean, Unit> $onFinish;
            {
                this.$onFinish = $onFinish;
                super(0);
            }

            public final void invoke() {
                this.$onFinish.invoke((Object)false);
            }
        };
        this.decoderInterface = new DecoderInterface(onFinish){
            final /* synthetic */ Function1<Boolean, Unit> $onFinish;
            {
                this.$onFinish = $onFinish;
            }

            public void onLoop() {
                this.$onFinish.invoke((Object)true);
            }
        };
        this.videoDecoder = new VideoDecoder(() -> VideoFileSource.videoDecoder$lambda$0(this.videoDecoderInterface), this.decoderInterface);
        this.setLoopMode(loopMode);
    }

    public /* synthetic */ VideoFileSource(Context context, Uri uri, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(context, uri, bl, (Function1<? super Boolean, Unit>)function1);
    }

    @Override
    protected boolean create(int width, int height, int fps, int rotation) {
        boolean result = this.videoDecoder.initExtractor(this.context, this.path, null);
        if (!result) {
            throw new IllegalArgumentException("Video file track not found");
        }
        return true;
    }

    @Override
    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.setSurfaceTexture(surfaceTexture);
        this.videoDecoder.prepareVideo(new Surface(surfaceTexture));
        this.videoDecoder.start();
        this.running = true;
    }

    @Override
    public void stop() {
        this.running = false;
        this.videoDecoder.stop();
    }

    @Override
    public void release() {
        if (this.running) {
            this.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    @NotNull
    public OrientationForced getOrientationConfig() {
        return OrientationForced.LANDSCAPE;
    }

    public final void moveTo(double time) {
        this.videoDecoder.moveTo(time);
    }

    public final double getDuration() {
        return this.videoDecoder.getDuration();
    }

    public final double getTime() {
        return this.videoDecoder.getTime();
    }

    public final void setLoopMode(boolean enabled) {
        this.videoDecoder.setLoopMode(enabled);
    }

    public final void replaceFile(@NotNull Context context, @NotNull Uri uri) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        int width = this.videoDecoder.getWidth();
        int height = this.videoDecoder.getHeight();
        boolean wasRunning = this.videoDecoder.isRunning();
        VideoDecoder videoDecoder = new VideoDecoder(() -> VideoFileSource.replaceFile$lambda$1(this.videoDecoderInterface), this.decoderInterface);
        if (!videoDecoder.initExtractor(context, uri, null)) {
            throw new IOException("Extraction failed");
        }
        if (width != videoDecoder.getWidth() || height != videoDecoder.getHeight()) {
            throw new IOException("Resolution must be the same that the previous file");
        }
        this.videoDecoder.stop();
        this.videoDecoder = videoDecoder;
        if (wasRunning) {
            videoDecoder.prepareVideo(new Surface(this.getSurfaceTexture()));
            videoDecoder.start();
        }
    }

    private static final void videoDecoder$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void replaceFile$lambda$1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }
}

