/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.content.Context;
import android.os.Build;
import android.util.Range;
import android.view.MotionEvent;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;

public class CameraHelper {
    private static final float[] verticesData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};

    public static float[] getVerticesData() {
        return verticesData;
    }

    public static int getCameraOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager != null) {
            int orientation = windowManager.getDefaultDisplay().getRotation();
            return switch (orientation) {
                case 0 -> 90;
                case 1 -> 0;
                case 2 -> 270;
                case 3 -> 180;
                default -> 0;
            };
        }
        return 0;
    }

    public static boolean isPortrait(Context context) {
        int orientation = CameraHelper.getCameraOrientation(context);
        return orientation == 90 || orientation == 270;
    }

    public static float getFingerSpacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    @RequiresApi(api=21)
    public static boolean discardCamera2Fps(Range<Integer> range, Facing facing) {
        if (Build.MODEL.equalsIgnoreCase("Pixel 4a")) {
            return facing == Facing.BACK && ((Integer)range.getUpper() == 30 || (Integer)range.getUpper() == 15);
        }
        return false;
    }

    public static enum Facing {
        BACK,
        FRONT;

    }
}

