/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.media.MediaExtractor;
import android.util.Log;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.BaseDecoder;
import com.pedro.encoder.utils.PCMUtil;
import java.nio.ByteBuffer;

public class AudioDecoder
extends BaseDecoder {
    private final AudioDecoderInterface audioDecoderInterface;
    private final GetMicrophoneData getMicrophoneData;
    private int sampleRate;
    private boolean isStereo;
    private int channels = 1;
    private int size = 2048;
    private byte[] pcmBuffer = new byte[this.size];
    private byte[] pcmBufferMuted = new byte[11];
    private boolean muted = false;

    public AudioDecoder(GetMicrophoneData getMicrophoneData, AudioDecoderInterface audioDecoderInterface) {
        this.TAG = "AudioDecoder";
        this.getMicrophoneData = getMicrophoneData;
        this.audioDecoderInterface = audioDecoderInterface;
    }

    @Override
    protected boolean extract(MediaExtractor audioExtractor) {
        this.size = 2048;
        for (int i = 0; i < audioExtractor.getTrackCount() && !this.mime.startsWith("audio/"); ++i) {
            this.mediaFormat = audioExtractor.getTrackFormat(i);
            this.mime = this.mediaFormat.getString("mime");
            if (this.mime.startsWith("audio/")) {
                audioExtractor.selectTrack(i);
                continue;
            }
            this.mediaFormat = null;
        }
        if (this.mediaFormat != null) {
            this.channels = this.mediaFormat.getInteger("channel-count");
            this.isStereo = this.channels >= 2;
            this.sampleRate = this.mediaFormat.getInteger("sample-rate");
            this.duration = this.mediaFormat.getLong("durationUs");
            this.fixBuffer();
            return true;
        }
        this.mime = "";
        return false;
    }

    private void fixBuffer() {
        if (this.channels >= 2) {
            this.size *= this.channels;
        }
        this.pcmBuffer = new byte[this.size];
    }

    public boolean prepareAudio() {
        return this.prepare(null);
    }

    @Override
    protected boolean decodeOutput(ByteBuffer outputBuffer) {
        long timeStamp = System.nanoTime() / 1000L;
        if (this.muted) {
            outputBuffer.get(this.pcmBufferMuted, 0, Math.min(outputBuffer.remaining(), this.pcmBufferMuted.length));
            this.getMicrophoneData.inputPCMData(new Frame(this.pcmBufferMuted, 0, this.pcmBufferMuted.length, timeStamp));
        } else {
            if (this.pcmBuffer.length < outputBuffer.remaining()) {
                this.pcmBuffer = new byte[outputBuffer.remaining()];
            }
            outputBuffer.get(this.pcmBuffer, 0, Math.min(outputBuffer.remaining(), this.pcmBuffer.length));
            if (this.channels > 2) {
                byte[] bufferStereo = PCMUtil.pcmToStereo(this.pcmBuffer, this.channels);
                this.getMicrophoneData.inputPCMData(new Frame(bufferStereo, 0, bufferStereo.length, timeStamp));
            } else {
                this.getMicrophoneData.inputPCMData(new Frame(this.pcmBuffer, 0, this.pcmBuffer.length, timeStamp));
            }
        }
        return false;
    }

    @Override
    protected void finished() {
        this.audioDecoderInterface.onAudioDecoderFinished();
    }

    public int getOutsize() {
        if (!(this.mime.equals("audio/mp4a-latm") || this.mime.equals("audio/opus") || this.mime.equals("audio/ogg"))) {
            Log.i((String)this.TAG, (String)"fixing input size");
            try {
                if (this.running) {
                    return this.codec.getOutputBuffers()[0].remaining();
                }
                if (this.codec != null) {
                    this.codec.start();
                    int outSize = this.codec.getOutputBuffers()[0].remaining();
                    this.stopDecoder();
                    if (this.prepare(null)) {
                        return outSize;
                    }
                }
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        }
        Log.i((String)this.TAG, (String)"default input size");
        return 0;
    }

    public void mute() {
        this.muted = true;
    }

    public void unMute() {
        this.muted = false;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isStereo() {
        return this.isStereo;
    }
}

