/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.render.CameraRender;
import com.pedro.encoder.input.gl.render.ScreenRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.NoFilterRender;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(api=18)
public class ManagerRender {
    public static int numFilters = 0;
    private final CameraRender cameraRender;
    private final List<BaseFilterRender> baseFilterRender = new ArrayList<BaseFilterRender>();
    private final ScreenRender screenRender;
    private int width;
    private int height;
    private int previewWidth;
    private int previewHeight;
    private Context context;

    public ManagerRender() {
        this.cameraRender = new CameraRender();
        this.screenRender = new ScreenRender();
    }

    public void initGl(Context context, int encoderWidth, int encoderHeight, int previewWidth, int previewHeight) {
        this.context = context;
        this.width = encoderWidth;
        this.height = encoderHeight;
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        this.cameraRender.initGl(this.width, this.height, context, previewWidth, previewHeight);
        this.screenRender.setStreamSize(encoderWidth, encoderHeight);
        this.screenRender.setTexId(this.cameraRender.getTexId());
        this.screenRender.initGl(context);
    }

    public void drawOffScreen() {
        this.cameraRender.draw();
        for (BaseFilterRender baseFilterRender : this.baseFilterRender) {
            baseFilterRender.draw();
        }
    }

    public void drawScreen(int width, int height, boolean keepAspectRatio, int mode, int rotation, boolean isPreview, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        this.screenRender.draw(width, height, keepAspectRatio, mode, rotation, isPreview, flipStreamVertical, flipStreamHorizontal);
    }

    public void release() {
        this.cameraRender.release();
        for (int i = 0; i < this.baseFilterRender.size(); ++i) {
            this.baseFilterRender.get(i).release();
            this.baseFilterRender.set(i, new NoFilterRender());
        }
        this.screenRender.release();
    }

    public void enableAA(boolean AAEnabled) {
        this.screenRender.setAAEnabled(AAEnabled);
    }

    public boolean isAAEnabled() {
        return this.screenRender.isAAEnabled();
    }

    public void updateFrame() {
        this.cameraRender.updateTexImage();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.cameraRender.getSurfaceTexture();
    }

    public Surface getSurface() {
        return this.cameraRender.getSurface();
    }

    private void setFilter(int position, BaseFilterRender baseFilterRender) {
        int texId = this.baseFilterRender.isEmpty() ? this.cameraRender.getTexId() : this.baseFilterRender.get(this.baseFilterRender.size() - 1).getTexId();
        this.baseFilterRender.get(position).release();
        this.baseFilterRender.set(position, baseFilterRender);
        baseFilterRender.setPreviousTexId(texId);
        baseFilterRender.initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        baseFilterRender.initFBOLink();
        this.reOrderFilters();
    }

    private void addFilter(BaseFilterRender baseFilterRender) {
        int texId = this.baseFilterRender.isEmpty() ? this.cameraRender.getTexId() : this.baseFilterRender.get(this.baseFilterRender.size() - 1).getTexId();
        this.baseFilterRender.add(baseFilterRender);
        baseFilterRender.setPreviousTexId(texId);
        baseFilterRender.initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        baseFilterRender.initFBOLink();
        this.reOrderFilters();
    }

    private void addFilter(int position, BaseFilterRender baseFilterRender) {
        int texId = position == 0 && this.baseFilterRender.size() == 1 ? this.cameraRender.getTexId() : this.baseFilterRender.get(position - 1).getTexId();
        this.baseFilterRender.add(position, baseFilterRender);
        baseFilterRender.setPreviousTexId(texId);
        baseFilterRender.initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        baseFilterRender.initFBOLink();
        this.reOrderFilters();
    }

    private void clearFilters() {
        for (BaseFilterRender baseFilterRender : this.baseFilterRender) {
            baseFilterRender.release();
        }
        this.baseFilterRender.clear();
        this.reOrderFilters();
    }

    private void removeFilter(int position) {
        this.baseFilterRender.get(position).release();
        this.baseFilterRender.remove(position);
        this.reOrderFilters();
    }

    private void reOrderFilters() {
        for (int i = 0; i < this.baseFilterRender.size(); ++i) {
            int texId = i == 0 ? this.cameraRender.getTexId() : this.baseFilterRender.get(i - 1).getTexId();
            this.baseFilterRender.get(i).setPreviousTexId(texId);
        }
        int texId = this.baseFilterRender.size() < 1 ? this.cameraRender.getTexId() : this.baseFilterRender.get(this.baseFilterRender.size() - 1).getTexId();
        this.screenRender.setTexId(texId);
    }

    public void setFilterAction(FilterAction filterAction, int position, BaseFilterRender baseFilterRender) {
        switch (filterAction) {
            case SET: {
                this.setFilter(position, baseFilterRender);
                break;
            }
            case ADD: {
                if (numFilters > 0 && this.baseFilterRender.size() >= numFilters) {
                    throw new RuntimeException("limit of filters(" + numFilters + ") exceeded");
                }
                this.addFilter(baseFilterRender);
                break;
            }
            case ADD_INDEX: {
                if (numFilters > 0 && this.baseFilterRender.size() >= numFilters) {
                    throw new RuntimeException("limit of filters(" + numFilters + ") exceeded");
                }
                this.addFilter(position, baseFilterRender);
                break;
            }
            case CLEAR: {
                this.clearFilters();
                break;
            }
            case REMOVE: {
                this.removeFilter(position);
                break;
            }
        }
    }

    public int filtersCount() {
        return this.baseFilterRender.size();
    }

    public void setCameraRotation(int rotation) {
        this.cameraRender.setRotation(rotation);
    }

    public void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.cameraRender.setFlip(isFlipHorizontal, isFlipVertical);
    }

    public void setPreviewSize(int previewWidth, int previewHeight) {
        for (int i = 0; i < this.baseFilterRender.size(); ++i) {
            this.baseFilterRender.get(i).setPreviewSize(previewWidth, previewHeight);
        }
    }
}

