/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.SizeCalculator;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

@RequiresApi(api=18)
public class SimpleCameraRender {
    public static final String TAG = "SimpleCameraRender";
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int SQUARE_VERTEX_DATA_STRIDE_BYTES = 20;
    private static final int SQUARE_VERTEX_DATA_POS_OFFSET = 0;
    private static final int SQUARE_VERTEX_DATA_UV_OFFSET = 3;
    private FloatBuffer squareVertex;
    private float[] MVPMatrix = new float[16];
    private float[] STMatrix = new float[16];
    private float[] rotationMatrix = new float[16];
    private float[] scaleMatrix = new float[16];
    private int[] texturesID = new int[1];
    private int program = -1;
    private int textureID = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int aPositionHandle = -1;
    private int aTextureCoordHandle = -1;
    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private int streamWidth;
    private int streamHeight;
    private boolean isPortrait;

    public SimpleCameraRender() {
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
        float[] vertex = CameraHelper.getVerticesData();
        this.squareVertex = ByteBuffer.allocateDirect(vertex.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(vertex).position(0);
        this.setRotation(0);
        this.setFlip(false, false);
    }

    public void setRotation(int rotation) {
        Matrix.setIdentityM((float[])this.rotationMatrix, (int)0);
        Matrix.rotateM((float[])this.rotationMatrix, (int)0, (float)rotation, (float)0.0f, (float)0.0f, (float)-1.0f);
        this.update();
    }

    public int getTextureId() {
        return this.textureID;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public void updateFrame() {
        this.surfaceTexture.updateTexImage();
    }

    public void drawFrame(int width, int height, boolean keepAspectRatio, int mode, int rotation, boolean isPreview, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        GlUtil.checkGlError("drawFrame start");
        this.surfaceTexture.getTransformMatrix(this.STMatrix);
        SizeCalculator.processMatrix(rotation, width, height, isPreview, this.isPortrait, flipStreamHorizontal, flipStreamVertical, mode, this.MVPMatrix);
        SizeCalculator.calculateViewPort(keepAspectRatio, mode, width, height, this.streamWidth, this.streamHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureCoordHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureCoordHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.textureID);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkGlError("drawFrame end");
    }

    public void initGl(Context context, int streamWidth, int streamHeight) {
        this.isPortrait = CameraHelper.isPortrait(context);
        this.streamWidth = streamWidth;
        this.streamHeight = streamHeight;
        GlUtil.checkGlError("initGl start");
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.camera_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureCoordHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        GlUtil.createExternalTextures(this.texturesID.length, this.texturesID, 0);
        this.textureID = this.texturesID[0];
        this.surfaceTexture = new SurfaceTexture(this.textureID);
        this.surfaceTexture.setDefaultBufferSize(streamWidth, streamHeight);
        this.surface = new Surface(this.surfaceTexture);
        GlUtil.checkGlError("initGl end");
    }

    public void release() {
        GLES20.glDeleteProgram((int)this.program);
        this.surfaceTexture.release();
        this.surface.release();
    }

    public void setFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        Matrix.setIdentityM((float[])this.scaleMatrix, (int)0);
        Matrix.scaleM((float[])this.scaleMatrix, (int)0, (float)(isFlipHorizontal ? -1.0f : 1.0f), (float)(isFlipVertical ? -1.0f : 1.0f), (float)1.0f);
        this.update();
    }

    private void update() {
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.multiplyMM((float[])this.MVPMatrix, (int)0, (float[])this.scaleMatrix, (int)0, (float[])this.MVPMatrix, (int)0);
        Matrix.multiplyMM((float[])this.MVPMatrix, (int)0, (float[])this.rotationMatrix, (int)0, (float[])this.MVPMatrix, (int)0);
    }
}

