/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.audio;

import android.media.AudioFormat;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.AudioPostProcessEffect;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.NoAudioEffect;
import java.nio.ByteBuffer;

public class MicrophoneManager {
    private final String TAG = "MicrophoneManager";
    private int BUFFER_SIZE = 0;
    protected AudioRecord audioRecord;
    private final GetMicrophoneData getMicrophoneData;
    protected ByteBuffer pcmBuffer = ByteBuffer.allocateDirect(this.BUFFER_SIZE);
    protected byte[] pcmBufferMuted = new byte[this.BUFFER_SIZE];
    protected boolean running = false;
    private boolean created = false;
    private int sampleRate = 32000;
    private final int audioFormat = 2;
    private int channel = 12;
    protected boolean muted = false;
    private AudioPostProcessEffect audioPostProcessEffect;
    protected HandlerThread handlerThread;
    protected CustomAudioEffect customAudioEffect = new NoAudioEffect();

    public MicrophoneManager(GetMicrophoneData getMicrophoneData) {
        this.getMicrophoneData = getMicrophoneData;
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.customAudioEffect = customAudioEffect;
    }

    public void createMicrophone() {
        this.createMicrophone(this.sampleRate, true, false, false);
        Log.i((String)"MicrophoneManager", (String)("Microphone created, " + this.sampleRate + "hz, Stereo"));
    }

    public boolean createMicrophone(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.createMicrophone(0, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean createMicrophone(int audioSource, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        try {
            String chl;
            this.sampleRate = sampleRate;
            this.channel = isStereo ? 12 : 16;
            this.audioRecord = new AudioRecord(audioSource, sampleRate, this.channel, 2, this.getPcmBufferSize());
            this.audioPostProcessEffect = new AudioPostProcessEffect(this.audioRecord.getAudioSessionId());
            if (echoCanceler) {
                this.audioPostProcessEffect.enableEchoCanceler();
            }
            if (noiseSuppressor) {
                this.audioPostProcessEffect.enableNoiseSuppressor();
            }
            String string = chl = isStereo ? "Stereo" : "Mono";
            if (this.audioRecord.getState() != 1) {
                throw new IllegalArgumentException("Some parameters specified is not valid");
            }
            Log.i((String)"MicrophoneManager", (String)("Microphone created, " + sampleRate + "hz, " + chl));
            this.created = true;
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"MicrophoneManager", (String)"create microphone error", (Throwable)e);
        }
        return this.created;
    }

    public boolean createInternalMicrophone(AudioPlaybackCaptureConfiguration config, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        try {
            String chl;
            if (Build.VERSION.SDK_INT >= 29) {
                this.sampleRate = sampleRate;
                this.channel = isStereo ? 12 : 16;
                this.audioRecord = new AudioRecord.Builder().setAudioPlaybackCaptureConfig(config).setAudioFormat(new AudioFormat.Builder().setEncoding(2).setSampleRate(sampleRate).setChannelMask(this.channel).build()).setBufferSizeInBytes(this.getPcmBufferSize()).build();
                this.audioPostProcessEffect = new AudioPostProcessEffect(this.audioRecord.getAudioSessionId());
                if (echoCanceler) {
                    this.audioPostProcessEffect.enableEchoCanceler();
                }
                if (noiseSuppressor) {
                    this.audioPostProcessEffect.enableNoiseSuppressor();
                }
                String string = chl = isStereo ? "Stereo" : "Mono";
                if (this.audioRecord.getState() != 1) {
                    throw new IllegalArgumentException("Some parameters specified is not valid");
                }
            } else {
                return this.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
            }
            Log.i((String)"MicrophoneManager", (String)("Internal microphone created, " + sampleRate + "hz, " + chl));
            this.created = true;
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"MicrophoneManager", (String)"create microphone error", (Throwable)e);
        }
        return this.created;
    }

    public boolean createInternalMicrophone(AudioPlaybackCaptureConfiguration config, int sampleRate, boolean isStereo) {
        return this.createInternalMicrophone(config, sampleRate, isStereo, false, false);
    }

    public synchronized void start() {
        this.init();
        this.handlerThread = new HandlerThread("MicrophoneManager");
        this.handlerThread.start();
        Handler handler = new Handler(this.handlerThread.getLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                while (MicrophoneManager.this.running) {
                    Frame frame = MicrophoneManager.this.read();
                    if (frame == null) continue;
                    MicrophoneManager.this.getMicrophoneData.inputPCMData(frame);
                }
            }
        });
    }

    private void init() {
        if (this.audioRecord != null) {
            this.audioRecord.startRecording();
            this.running = true;
            Log.i((String)"MicrophoneManager", (String)"Microphone started");
        } else {
            Log.e((String)"MicrophoneManager", (String)"Error starting, microphone was stopped or not created, use createMicrophone() before start()");
        }
    }

    public void mute() {
        this.muted = true;
    }

    public void unMute() {
        this.muted = false;
    }

    public boolean isMuted() {
        return this.muted;
    }

    private Frame read() {
        this.pcmBuffer.rewind();
        int size = this.audioRecord.read(this.pcmBuffer, this.pcmBuffer.remaining());
        if (size < 0) {
            return null;
        }
        return new Frame(this.muted ? this.pcmBufferMuted : this.customAudioEffect.process(this.pcmBuffer.array()), this.muted ? 0 : this.pcmBuffer.arrayOffset(), size);
    }

    public synchronized void stop() {
        this.running = false;
        this.created = false;
        if (this.handlerThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                this.handlerThread.quitSafely();
            } else {
                this.handlerThread.quit();
            }
        }
        if (this.audioRecord != null) {
            this.audioRecord.setRecordPositionUpdateListener(null);
            this.audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
        if (this.audioPostProcessEffect != null) {
            this.audioPostProcessEffect.releaseEchoCanceler();
            this.audioPostProcessEffect.releaseNoiseSuppressor();
        }
        Log.i((String)"MicrophoneManager", (String)"Microphone stopped");
    }

    private int getPcmBufferSize() {
        this.BUFFER_SIZE = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channel, (int)2);
        this.pcmBuffer = ByteBuffer.allocateDirect(this.BUFFER_SIZE);
        this.pcmBufferMuted = new byte[this.BUFFER_SIZE];
        return this.BUFFER_SIZE * 5;
    }

    public int getMaxInputSize() {
        return this.BUFFER_SIZE;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getAudioFormat() {
        return 2;
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isCreated() {
        return this.created;
    }
}

