/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.CameraRender;
import com.pedro.encoder.input.gl.render.RenderHandler;
import com.pedro.encoder.input.gl.render.ScreenRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.NoFilterRender;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(api=18)
public class ManagerRender {
    public static int numFilters = 1;
    private CameraRender cameraRender;
    private List<BaseFilterRender> baseFilterRender = new ArrayList<BaseFilterRender>(numFilters);
    private ScreenRender screenRender;
    private int width;
    private int height;
    private int previewWidth;
    private int previewHeight;
    private Context context;

    public ManagerRender() {
        this.cameraRender = new CameraRender();
        for (int i = 0; i < numFilters; ++i) {
            this.baseFilterRender.add(new NoFilterRender());
        }
        this.screenRender = new ScreenRender();
    }

    public void initGl(Context context, int encoderWidth, int encoderHeight, int previewWidth, int previewHeight) {
        this.context = context;
        this.width = encoderWidth;
        this.height = encoderHeight;
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        this.cameraRender.initGl(this.width, this.height, context, previewWidth, previewHeight);
        for (int i = 0; i < numFilters; ++i) {
            int textId = i == 0 ? this.cameraRender.getTexId() : this.baseFilterRender.get(i - 1).getTexId();
            this.baseFilterRender.get(i).setPreviousTexId(textId);
            this.baseFilterRender.get(i).initGl(this.width, this.height, context, previewWidth, previewHeight);
            this.baseFilterRender.get(i).initFBOLink();
        }
        this.screenRender.setStreamSize(encoderWidth, encoderHeight);
        this.screenRender.setTexId(this.baseFilterRender.get(numFilters - 1).getTexId());
        this.screenRender.initGl(context);
    }

    public void drawOffScreen() {
        this.cameraRender.draw();
        for (BaseFilterRender baseFilterRender : this.baseFilterRender) {
            baseFilterRender.draw();
        }
    }

    public void drawScreen(int width, int height, boolean keepAspectRatio, int mode, int rotation, boolean isPreview, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        this.screenRender.draw(width, height, keepAspectRatio, mode, rotation, isPreview, flipStreamVertical, flipStreamHorizontal);
    }

    public void release() {
        this.cameraRender.release();
        for (int i = 0; i < this.baseFilterRender.size(); ++i) {
            this.baseFilterRender.get(i).release();
            this.baseFilterRender.set(i, new NoFilterRender());
        }
        this.screenRender.release();
    }

    public void enableAA(boolean AAEnabled) {
        this.screenRender.setAAEnabled(AAEnabled);
    }

    public boolean isAAEnabled() {
        return this.screenRender.isAAEnabled();
    }

    public void updateFrame() {
        this.cameraRender.updateTexImage();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.cameraRender.getSurfaceTexture();
    }

    public Surface getSurface() {
        return this.cameraRender.getSurface();
    }

    public void setFilter(int position, BaseFilterRender baseFilterRender) {
        int id = this.baseFilterRender.get(position).getPreviousTexId();
        RenderHandler renderHandler = this.baseFilterRender.get(position).getRenderHandler();
        this.baseFilterRender.get(position).release();
        this.baseFilterRender.set(position, baseFilterRender);
        this.baseFilterRender.get(position).setPreviousTexId(id);
        this.baseFilterRender.get(position).initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        this.baseFilterRender.get(position).setRenderHandler(renderHandler);
    }

    public void setCameraRotation(int rotation) {
        this.cameraRender.setRotation(rotation);
    }

    public void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.cameraRender.setFlip(isFlipHorizontal, isFlipVertical);
    }

    public void setPreviewSize(int previewWidth, int previewHeight) {
        for (int i = 0; i < this.baseFilterRender.size(); ++i) {
            this.baseFilterRender.get(i).setPreviewSize(previewWidth, previewHeight);
        }
    }
}

