/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.graphics.Point;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Pair;

public class SizeCalculator {
    public static void calculateViewPort(boolean keepAspectRatio, int mode, int previewWidth, int previewHeight, int streamWidth, int streamHeight) {
        Pair<Point, Point> pair = SizeCalculator.getViewport(keepAspectRatio, mode, previewWidth, previewHeight, streamWidth, streamHeight);
        GLES20.glViewport((int)((Point)pair.first).x, (int)((Point)pair.first).y, (int)((Point)pair.second).x, (int)((Point)pair.second).y);
    }

    public static Pair<Point, Point> getViewport(boolean keepAspectRatio, int mode, int previewWidth, int previewHeight, int streamWidth, int streamHeight) {
        if (keepAspectRatio) {
            float streamAspectRatio = (float)streamWidth / (float)streamHeight;
            float previewAspectRatio = (float)previewWidth / (float)previewHeight;
            int xo = 0;
            int yo = 0;
            int xf = previewWidth;
            int yf = previewHeight;
            if (streamAspectRatio > 1.0f && previewAspectRatio > 1.0f && streamAspectRatio > previewAspectRatio || streamAspectRatio < 1.0f && previewAspectRatio < 1.0f && streamAspectRatio > previewAspectRatio || streamAspectRatio > 1.0f && previewAspectRatio < 1.0f) {
                if (mode == 0 || mode == 2) {
                    yf = streamHeight * previewWidth / streamWidth;
                    yo = (yf - previewHeight) / 2 * -1;
                } else {
                    xf = streamWidth * previewHeight / streamHeight;
                    xo = (xf - previewWidth) / 2 * -1;
                }
            } else if (streamAspectRatio > 1.0f && previewAspectRatio > 1.0f && streamAspectRatio < previewAspectRatio || streamAspectRatio < 1.0f && previewAspectRatio < 1.0f && streamAspectRatio < previewAspectRatio || streamAspectRatio < 1.0f && previewAspectRatio > 1.0f) {
                if (mode == 0 || mode == 2) {
                    xf = streamWidth * previewHeight / streamHeight;
                    xo = (xf - previewWidth) / 2 * -1;
                } else {
                    yf = streamHeight * previewWidth / streamWidth;
                    yo = (yf - previewHeight) / 2 * -1;
                }
            }
            return new Pair((Object)new Point(xo, yo), (Object)new Point(xf, yf));
        }
        return new Pair((Object)new Point(0, 0), (Object)new Point(previewWidth, previewHeight));
    }

    public static void processMatrix(int rotation, int width, int height, boolean isPreview, boolean isPortrait, boolean flipStreamHorizontal, boolean flipStreamVertical, int mode, float[] MVPMatrix) {
        PointF scale;
        if (mode == 2 || mode == 3) {
            scale = SizeCalculator.getScale(rotation, width, height, isPortrait, isPreview);
            if (!isPreview && !isPortrait) {
                rotation += 90;
            }
        } else {
            scale = new PointF(1.0f, 1.0f);
        }
        if (!isPreview) {
            float xFlip = flipStreamHorizontal ? -1.0f : 1.0f;
            float yFlip = flipStreamVertical ? -1.0f : 1.0f;
            scale = new PointF(scale.x * xFlip, scale.y * yFlip);
        }
        SizeCalculator.updateMatrix(rotation, scale, MVPMatrix);
    }

    private static void updateMatrix(int rotation, PointF scale, float[] MVPMatrix) {
        Matrix.setIdentityM((float[])MVPMatrix, (int)0);
        Matrix.scaleM((float[])MVPMatrix, (int)0, (float)scale.x, (float)scale.y, (float)1.0f);
        Matrix.rotateM((float[])MVPMatrix, (int)0, (float)rotation, (float)0.0f, (float)0.0f, (float)-1.0f);
    }

    private static PointF getScale(int rotation, int width, int height, boolean isPortrait, boolean isPreview) {
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (!isPreview) {
            if (isPortrait && rotation != 0 && rotation != 180) {
                float adjustedWidth = (float)width * ((float)width / (float)height);
                scaleY = adjustedWidth / (float)height;
            } else if (!isPortrait && rotation != 90 && rotation != 270) {
                float adjustedWidth = (float)height * ((float)height / (float)width);
                scaleX = adjustedWidth / (float)width;
            }
        }
        return new PointF(scaleX, scaleY);
    }
}

