/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaCodec;
import android.media.MediaDataSource;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.decoder.LoopFileInterface;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;

public abstract class BaseDecoder {
    protected static final String TAG = "BaseDecoder";
    protected LoopFileInterface loopFileInterface;
    protected MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
    protected MediaExtractor extractor;
    protected MediaCodec codec;
    protected volatile boolean running = false;
    protected MediaFormat mediaFormat;
    private HandlerThread handlerThread;
    protected String mime = "";
    protected boolean loopMode = false;
    protected volatile long seekTime = 0L;
    protected volatile long startMs = 0L;
    protected long duration;

    public BaseDecoder(LoopFileInterface loopFileInterface) {
        this.loopFileInterface = loopFileInterface;
    }

    public boolean initExtractor(String filePath) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(filePath);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(FileDescriptor fileDescriptor) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(fileDescriptor);
        return this.extract(this.extractor);
    }

    @RequiresApi(api=24)
    public boolean initExtractor(AssetFileDescriptor assetFileDescriptor) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(assetFileDescriptor);
        return this.extract(this.extractor);
    }

    @RequiresApi(api=23)
    public boolean initExtractor(MediaDataSource mediaDataSource) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(mediaDataSource);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(String filePath, Map<String, String> headers) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(filePath, headers);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(FileDescriptor fileDescriptor, long offset, long length) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(fileDescriptor, offset, length);
        return this.extract(this.extractor);
    }

    public boolean initExtractor(Context context, Uri uri, Map<String, String> headers) throws IOException {
        this.extractor = new MediaExtractor();
        this.extractor.setDataSource(context, uri, headers);
        return this.extract(this.extractor);
    }

    public void start() {
        this.running = true;
        this.handlerThread = new HandlerThread(TAG);
        this.handlerThread.start();
        Handler handler = new Handler(this.handlerThread.getLooper());
        this.codec.start();
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseDecoder.this.decode();
                }
                catch (IllegalStateException e) {
                    Log.i((String)BaseDecoder.TAG, (String)"Decoding error", (Throwable)e);
                }
                catch (NullPointerException e) {
                    Log.i((String)BaseDecoder.TAG, (String)"Decoder maybe was stopped");
                    Log.i((String)BaseDecoder.TAG, (String)"Decoding error", (Throwable)e);
                }
            }
        });
    }

    public void stop() {
        this.stopDecoder();
        if (this.extractor != null) {
            this.extractor.release();
            this.extractor = null;
            this.mime = "";
        }
    }

    protected boolean prepare(Surface surface) {
        try {
            this.codec = MediaCodec.createDecoderByType((String)this.mime);
            this.codec.configure(this.mediaFormat, surface, null, 0);
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Prepare decoder error:", (Throwable)e);
            return false;
        }
    }

    protected void resetCodec(Surface surface) {
        boolean wasRunning = this.running;
        this.stopDecoder();
        if (this.extractor != null) {
            this.seekTime = this.extractor.getSampleTime() / 1000L;
        }
        this.prepare(surface);
        if (wasRunning) {
            this.start();
        }
    }

    protected void stopDecoder() {
        this.running = false;
        this.seekTime = 0L;
        if (this.handlerThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                this.handlerThread.quitSafely();
            } else {
                this.handlerThread.quit();
            }
        }
        try {
            this.codec.stop();
            this.codec = null;
        }
        catch (IllegalStateException | NullPointerException e) {
            this.codec = null;
        }
    }

    public void moveTo(double time) {
        this.extractor.seekTo((long)(time * 1000000.0), 2);
        this.seekTime = this.extractor.getSampleTime() / 1000L;
        this.startMs = System.currentTimeMillis();
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
    }

    public double getDuration() {
        return (double)this.duration / 1000000.0;
    }

    public double getTime() {
        if (this.running) {
            return (double)this.extractor.getSampleTime() / 1000000.0;
        }
        return 0.0;
    }

    protected abstract boolean extract(MediaExtractor var1);

    protected abstract void decode();
}

