/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.audio;

import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AutomaticGainControl;
import android.media.audiofx.NoiseSuppressor;
import android.util.Log;

public class AudioPostProcessEffect {
    private final String TAG = "AudioPostProcessEffect";
    private int microphoneId;
    private AcousticEchoCanceler acousticEchoCanceler = null;
    private AutomaticGainControl automaticGainControl = null;
    private NoiseSuppressor noiseSuppressor = null;

    public AudioPostProcessEffect(int microphoneId) {
        this.microphoneId = microphoneId;
    }

    public void enableAutoGainControl() {
        if (AutomaticGainControl.isAvailable() && this.automaticGainControl == null) {
            this.automaticGainControl = AutomaticGainControl.create((int)this.microphoneId);
            if (this.automaticGainControl != null) {
                this.automaticGainControl.setEnabled(true);
                Log.i((String)"AudioPostProcessEffect", (String)"AutoGainControl enabled");
                return;
            }
        }
        Log.e((String)"AudioPostProcessEffect", (String)"This device does't implement AutoGainControl");
    }

    public void releaseAutoGainControl() {
        if (this.automaticGainControl != null) {
            this.automaticGainControl.setEnabled(false);
            this.automaticGainControl.release();
            this.automaticGainControl = null;
        }
    }

    public void enableEchoCanceler() {
        if (AcousticEchoCanceler.isAvailable() && this.acousticEchoCanceler == null) {
            this.acousticEchoCanceler = AcousticEchoCanceler.create((int)this.microphoneId);
            if (this.acousticEchoCanceler != null) {
                this.acousticEchoCanceler.setEnabled(true);
                Log.i((String)"AudioPostProcessEffect", (String)"EchoCanceler enabled");
                return;
            }
        }
        Log.e((String)"AudioPostProcessEffect", (String)"This device does't implement EchoCanceler");
    }

    public void releaseEchoCanceler() {
        if (this.acousticEchoCanceler != null) {
            this.acousticEchoCanceler.setEnabled(false);
            this.acousticEchoCanceler.release();
            this.acousticEchoCanceler = null;
        }
    }

    public void enableNoiseSuppressor() {
        if (NoiseSuppressor.isAvailable() && this.noiseSuppressor == null) {
            this.noiseSuppressor = NoiseSuppressor.create((int)this.microphoneId);
            if (this.noiseSuppressor != null) {
                this.noiseSuppressor.setEnabled(true);
                Log.i((String)"AudioPostProcessEffect", (String)"NoiseSuppressor enabled");
                return;
            }
        }
        Log.e((String)"AudioPostProcessEffect", (String)"This device does't implement NoiseSuppressor");
    }

    public void releaseNoiseSuppressor() {
        if (this.noiseSuppressor != null) {
            this.noiseSuppressor.setEnabled(false);
            this.noiseSuppressor.release();
            this.noiseSuppressor = null;
        }
    }
}

