/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.media.MediaExtractor;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import com.pedro.encoder.input.decoder.BaseDecoder;
import com.pedro.encoder.input.decoder.LoopFileInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import java.nio.ByteBuffer;

public class VideoDecoder
extends BaseDecoder {
    private VideoDecoderInterface videoDecoderInterface;
    private int width;
    private int height;

    public VideoDecoder(VideoDecoderInterface videoDecoderInterface, LoopFileInterface loopFileInterface) {
        super(loopFileInterface);
        this.videoDecoderInterface = videoDecoderInterface;
    }

    @Override
    protected boolean extract(MediaExtractor videoExtractor) {
        this.running = false;
        for (int i = 0; i < videoExtractor.getTrackCount() && !this.mime.startsWith("video/"); ++i) {
            this.mediaFormat = videoExtractor.getTrackFormat(i);
            this.mime = this.mediaFormat.getString("mime");
            if (this.mime.startsWith("video/")) {
                videoExtractor.selectTrack(i);
                continue;
            }
            this.mediaFormat = null;
        }
        if (this.mediaFormat != null) {
            this.width = this.mediaFormat.getInteger("width");
            this.height = this.mediaFormat.getInteger("height");
            this.duration = this.mediaFormat.getLong("durationUs");
            return true;
        }
        this.mime = "";
        this.mediaFormat = null;
        return false;
    }

    public boolean prepareVideo(Surface surface) {
        return this.prepare(surface);
    }

    public void reset(Surface surface) {
        this.resetCodec(surface);
    }

    @Override
    protected void decode() {
        ByteBuffer[] inputBuffers = this.codec.getInputBuffers();
        this.startMs = System.currentTimeMillis();
        while (this.running) {
            int outIndex;
            int inIndex = this.codec.dequeueInputBuffer(10000L);
            if (inIndex >= 0) {
                ByteBuffer buffer = inputBuffers[inIndex];
                int sampleSize = this.extractor.readSampleData(buffer, 0);
                if (sampleSize < 0) {
                    this.codec.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                } else {
                    this.codec.queueInputBuffer(inIndex, 0, sampleSize, this.extractor.getSampleTime(), 0);
                    this.extractor.advance();
                }
            }
            if ((outIndex = this.codec.dequeueOutputBuffer(this.bufferInfo, 10000L)) >= 0) {
                while (this.extractor.getSampleTime() / 1000L > System.currentTimeMillis() - this.startMs + this.seekTime) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                this.codec.releaseOutputBuffer(outIndex, this.bufferInfo.size != 0);
            }
            if ((this.bufferInfo.flags & 4) == 0) continue;
            this.seekTime = 0L;
            Log.i((String)"BaseDecoder", (String)"end of file out");
            if (this.loopMode) {
                this.loopFileInterface.onReset(true);
                continue;
            }
            this.videoDecoderInterface.onVideoDecoderFinished();
        }
    }

    public void changeOutputSurface(Surface surface) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.codec.setOutputSurface(surface);
        } else {
            this.reset(surface);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

