/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;

public class SizeCalculator {
    public static void calculateViewPort(boolean keepAspectRatio, int mode, int previewWidth, int previewHeight, int streamWidth, int streamHeight) {
        if (keepAspectRatio) {
            if (previewWidth > previewHeight) {
                if (mode == 0) {
                    int realWidth = previewHeight * streamWidth / streamHeight;
                    GLES20.glViewport((int)((previewWidth - realWidth) / 2), (int)0, (int)realWidth, (int)previewHeight);
                } else {
                    int realHeight = previewWidth * streamHeight / streamWidth;
                    GLES20.glViewport((int)0, (int)(-((realHeight - previewWidth) / 2)), (int)previewWidth, (int)realHeight);
                }
            } else if (mode == 0) {
                int realHeight = previewWidth * streamHeight / streamWidth;
                GLES20.glViewport((int)0, (int)((previewHeight - realHeight) / 2), (int)previewWidth, (int)realHeight);
            } else {
                int realWidth = previewHeight * streamWidth / streamHeight;
                GLES20.glViewport((int)(-((realWidth - previewWidth) / 2)), (int)0, (int)realWidth, (int)previewHeight);
            }
        } else {
            GLES20.glViewport((int)0, (int)0, (int)previewWidth, (int)previewHeight);
        }
    }

    public static void updateMatrix(int rotation, int width, int height, boolean isPreview, boolean isPortrait, float[] MVPMatrix) {
        Matrix.setIdentityM((float[])MVPMatrix, (int)0);
        PointF scale = SizeCalculator.getScale(rotation, width, height, isPortrait, isPreview);
        Matrix.scaleM((float[])MVPMatrix, (int)0, (float)scale.x, (float)scale.y, (float)1.0f);
        if (!isPreview && !isPortrait) {
            rotation += 90;
        }
        Matrix.rotateM((float[])MVPMatrix, (int)0, (float)rotation, (float)0.0f, (float)0.0f, (float)-1.0f);
    }

    private static PointF getScale(int rotation, int width, int height, boolean isPortrait, boolean isPreview) {
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (!isPreview) {
            if (isPortrait && rotation != 0 && rotation != 180) {
                float adjustedWidth = (float)width * ((float)width / (float)height);
                scaleY = adjustedWidth / (float)height;
            } else if (!isPortrait && rotation != 90 && rotation != 270) {
                float adjustedWidth = (float)height * ((float)height / (float)width);
                scaleX = adjustedWidth / (float)width;
            }
        }
        return new PointF(scaleX, scaleY);
    }
}

