/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.filters.object.BaseObjectFilterRender;
import com.pedro.encoder.input.video.CameraHelper;

@RequiresApi(api=18)
public class SpriteGestureController {
    private BaseObjectFilterRender baseObjectFilterRender;
    private float lastDistance;
    private boolean preventMoveOutside = true;

    public SpriteGestureController() {
    }

    public SpriteGestureController(BaseObjectFilterRender sprite) {
        this.baseObjectFilterRender = sprite;
    }

    public BaseObjectFilterRender getBaseObjectFilterRender() {
        return this.baseObjectFilterRender;
    }

    public void setBaseObjectFilterRender(BaseObjectFilterRender baseObjectFilterRender) {
        this.baseObjectFilterRender = baseObjectFilterRender;
    }

    public void setPreventMoveOutside(boolean preventMoveOutside) {
        this.preventMoveOutside = preventMoveOutside;
    }

    public boolean spriteTouched(View view, MotionEvent motionEvent) {
        if (this.baseObjectFilterRender == null) {
            return false;
        }
        float xPercent = motionEvent.getX() * 100.0f / (float)view.getWidth();
        float yPercent = motionEvent.getY() * 100.0f / (float)view.getHeight();
        PointF scale = this.baseObjectFilterRender.getScale();
        PointF position = this.baseObjectFilterRender.getPosition();
        boolean xTouched = xPercent >= position.x && xPercent <= position.x + scale.x;
        boolean yTouched = yPercent >= position.y && yPercent <= position.y + scale.y;
        return xTouched && yTouched;
    }

    public void moveSprite(View view, MotionEvent motionEvent) {
        if (this.baseObjectFilterRender == null) {
            return;
        }
        if (motionEvent.getPointerCount() == 1) {
            float xPercent = motionEvent.getX() * 100.0f / (float)view.getWidth();
            float yPercent = motionEvent.getY() * 100.0f / (float)view.getHeight();
            PointF scale = this.baseObjectFilterRender.getScale();
            if (this.preventMoveOutside) {
                float x = xPercent - scale.x / 2.0f;
                float y = yPercent - scale.y / 2.0f;
                if (x < 0.0f) {
                    x = 0.0f;
                }
                if (x + scale.x > 100.0f) {
                    x = 100.0f - scale.x;
                }
                if (y < 0.0f) {
                    y = 0.0f;
                }
                if (y + scale.y > 100.0f) {
                    y = 100.0f - scale.y;
                }
                this.baseObjectFilterRender.setPosition(x, y);
            } else {
                this.baseObjectFilterRender.setPosition(xPercent - scale.x / 2.0f, yPercent - scale.y / 2.0f);
            }
        }
    }

    public void scaleSprite(MotionEvent motionEvent) {
        if (this.baseObjectFilterRender == null) {
            return;
        }
        if (motionEvent.getPointerCount() > 1) {
            float distance = CameraHelper.getFingerSpacing(motionEvent);
            float percent = distance >= this.lastDistance ? 1.0f : -1.0f;
            PointF scale = this.baseObjectFilterRender.getScale();
            scale.x += percent;
            scale.y += percent;
            this.baseObjectFilterRender.setScale(scale.x, scale.y);
            this.lastDistance = distance;
        }
    }
}

