/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.TranslateTo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@RequiresApi(api=18)
public class AndroidViewFilterRender
extends BaseFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uSamplerViewHandle = -1;
    private int[] viewId = new int[1];
    private View view;
    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private Handler mainHandler;
    private int rotation;
    private float positionX;
    private float positionY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float viewX;
    private float viewY;

    public AndroidViewFilterRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.android_view_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uSamplerViewHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSamplerView");
        GlUtil.createExternalTextures(1, this.viewId, 0);
        this.surfaceTexture = new SurfaceTexture(this.viewId[0]);
        this.surface = new Surface(this.surfaceTexture);
    }

    @Override
    protected void drawFilter() {
        this.surfaceTexture.setDefaultBufferSize(this.getPreviewWidth(), this.getPreviewHeight());
        if (this.view != null) {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    Canvas canvas = AndroidViewFilterRender.this.surface.lockCanvas(null);
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    canvas.translate(AndroidViewFilterRender.this.positionX, AndroidViewFilterRender.this.positionY);
                    canvas.rotate((float)AndroidViewFilterRender.this.rotation, AndroidViewFilterRender.this.viewX / 2.0f, AndroidViewFilterRender.this.viewY / 2.0f);
                    canvas.scale(AndroidViewFilterRender.this.scaleX, AndroidViewFilterRender.this.scaleY);
                    AndroidViewFilterRender.this.view.draw(canvas);
                    AndroidViewFilterRender.this.surface.unlockCanvasAndPost(canvas);
                }
            });
        }
        this.surfaceTexture.updateTexImage();
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)4);
        GLES20.glActiveTexture((int)33988);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
        GLES20.glUniform1i((int)this.uSamplerViewHandle, (int)5);
        GLES20.glActiveTexture((int)33989);
        GLES20.glBindTexture((int)36197, (int)this.viewId[0]);
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
        if (view != null) {
            view.measure(0, 0);
            this.viewX = view.getMeasuredWidth();
            this.viewY = view.getMeasuredHeight();
        }
    }

    public void setPosition(float x, float y) {
        int previewX = this.getPreviewWidth();
        int previewY = this.getPreviewHeight();
        this.positionX = (float)previewX * x / 100.0f;
        this.positionY = (float)previewY * y / 100.0f;
    }

    public void setPosition(TranslateTo positionTo) {
        int previewX = this.getPreviewWidth();
        int previewY = this.getPreviewHeight();
        switch (positionTo) {
            case TOP: {
                this.positionX = (float)previewX / 2.0f - this.viewX / 2.0f;
                this.positionY = 0.0f;
                break;
            }
            case LEFT: {
                this.positionX = 0.0f;
                this.positionY = (float)previewY / 2.0f - this.viewY / 2.0f;
                break;
            }
            case RIGHT: {
                this.positionX = (float)previewX - this.viewX;
                this.positionY = (float)previewY / 2.0f - this.viewY / 2.0f;
                break;
            }
            case BOTTOM: {
                this.positionX = (float)previewX / 2.0f - this.viewX / 2.0f;
                this.positionY = (float)previewY - this.viewY;
                break;
            }
            case CENTER: {
                this.positionX = (float)previewX / 2.0f - this.viewX / 2.0f;
                this.positionY = (float)previewY / 2.0f - this.viewY / 2.0f;
                break;
            }
            case TOP_RIGHT: {
                this.positionX = (float)previewX - this.viewX;
                this.positionY = 0.0f;
                break;
            }
            case BOTTOM_LEFT: {
                this.positionX = 0.0f;
                this.positionY = (float)previewY - this.viewY;
                break;
            }
            case BOTTOM_RIGHT: {
                this.positionX = (float)previewX - this.viewX;
                this.positionY = (float)previewY - this.viewY;
                break;
            }
            default: {
                this.positionX = 0.0f;
                this.positionY = 0.0f;
            }
        }
    }

    public void setRotation(int rotation) {
        this.rotation = rotation < 0 ? 0 : (rotation > 360 ? 360 : rotation);
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }
}

