/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.audio;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import com.pedro.encoder.BaseEncoder;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.utils.CodecUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AudioEncoder
extends BaseEncoder
implements GetMicrophoneData {
    private static final String TAG = "AudioEncoder";
    private GetAacData getAacData;
    private int bitRate = 65536;
    private int sampleRate = 32000;
    private boolean isStereo = true;

    public AudioEncoder(GetAacData getAacData) {
        this.getAacData = getAacData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean prepareAudioEncoder(int bitRate, int sampleRate, boolean isStereo, int maxInputSize) {
        this.sampleRate = sampleRate;
        this.isBufferMode = true;
        try {
            List<Object> encoders = new ArrayList();
            if (this.force == CodecUtil.Force.HARDWARE) {
                encoders = CodecUtil.getAllHardwareEncoders("audio/mp4a-latm");
            } else if (this.force == CodecUtil.Force.SOFTWARE) {
                encoders = CodecUtil.getAllSoftwareEncoders("audio/mp4a-latm");
            }
            if (this.force == CodecUtil.Force.FIRST_COMPATIBLE_FOUND) {
                MediaCodecInfo encoder = this.chooseEncoder("audio/mp4a-latm");
                if (encoder == null) {
                    Log.e((String)TAG, (String)"Valid encoder not found");
                    return false;
                }
                this.codec = MediaCodec.createByCodecName((String)encoder.getName());
            } else {
                if (encoders.isEmpty()) {
                    Log.e((String)TAG, (String)"Valid encoder not found");
                    return false;
                }
                this.codec = MediaCodec.createByCodecName((String)((MediaCodecInfo)encoders.get(0)).getName());
            }
            int channelCount = isStereo ? 2 : 1;
            MediaFormat audioFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
            audioFormat.setInteger("bitrate", bitRate);
            audioFormat.setInteger("max-input-size", maxInputSize);
            audioFormat.setInteger("aac-profile", 2);
            this.codec.configure(audioFormat, null, null, 1);
            this.running = false;
            Log.i((String)TAG, (String)"prepared");
            return true;
        }
        catch (IOException | IllegalStateException e) {
            Log.e((String)TAG, (String)"Create AudioEncoder failed.", (Throwable)e);
            return false;
        }
    }

    public boolean prepareAudioEncoder() {
        return this.prepareAudioEncoder(this.bitRate, this.sampleRate, this.isStereo, 0);
    }

    @Override
    public void start(boolean resetTs) {
        this.presentTimeUs = System.nanoTime() / 1000L;
        this.codec.start();
        this.running = true;
        Log.i((String)TAG, (String)"started");
    }

    @Override
    protected void stopImp() {
        Log.i((String)TAG, (String)"stopped");
    }

    @Override
    protected Frame getInputFrame() throws InterruptedException {
        return (Frame)this.queue.take();
    }

    @Override
    protected void checkBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
    }

    @Override
    protected void sendBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        bufferInfo.presentationTimeUs = System.nanoTime() / 1000L - this.presentTimeUs;
        this.getAacData.getAacData(byteBuffer, bufferInfo);
    }

    @Override
    public void inputPCMData(Frame frame) {
        if (this.running && this.queue.offer(frame)) {
            this.getDataFromEncoder();
        } else {
            Log.i((String)TAG, (String)"frame discarded");
        }
    }

    @Override
    protected MediaCodecInfo chooseEncoder(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (name.contains("omx.google")) continue;
            return mediaCodecInfo;
        }
        if (mediaCodecInfoList.size() > 0) {
            return mediaCodecInfoList.get(0);
        }
        return null;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    @Override
    public void formatChanged(@NonNull MediaCodec mediaCodec, @NonNull MediaFormat mediaFormat) {
        this.getAacData.onAudioFormat(mediaFormat);
    }
}

