/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CodecUtil {
    private static final String TAG = "CodecUtil";
    public static final String H264_MIME = "video/avc";
    public static final String H265_MIME = "video/hevc";
    public static final String AAC_MIME = "audio/mp4a-latm";

    /*
     * Could not resolve type clashes
     */
    @RequiresApi(api=23)
    public static List<String> showAllCodecsInfo() {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllCodecs();
        ArrayList<String> infos = new ArrayList<String>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String info = "----------------\n";
            info = info + "Name: " + mediaCodecInfo.getName() + "\n";
            for (String type : mediaCodecInfo.getSupportedTypes()) {
                MediaCodecInfo.VideoCapabilities videoCapabilities;
                int n;
                MediaCodecInfo.CodecProfileLevel[] encoderCapabilities;
                info = info + "Type: " + type + "\n";
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(type);
                info = info + "Max instances: " + codecCapabilities.getMaxSupportedInstances() + "\n";
                if (mediaCodecInfo.isEncoder()) {
                    info = info + "----- Encoder info -----\n";
                    encoderCapabilities = codecCapabilities.getEncoderCapabilities();
                    info = info + "Complexity range: " + encoderCapabilities.getComplexityRange().getLower() + " - " + encoderCapabilities.getComplexityRange().getUpper() + "\n";
                    info = info + "Quality range: " + encoderCapabilities.getQualityRange().getLower() + " - " + encoderCapabilities.getQualityRange().getUpper() + "\n";
                    info = info + "CBR supported: " + encoderCapabilities.isBitrateModeSupported(2) + "\n";
                    info = info + "VBR supported: " + encoderCapabilities.isBitrateModeSupported(1) + "\n";
                    info = info + "CQ supported: " + encoderCapabilities.isBitrateModeSupported(0) + "\n";
                    info = info + "----- -----\n";
                } else {
                    info = info + "----- Decoder info -----\n";
                    info = info + "----- -----\n";
                }
                if (codecCapabilities.colorFormats != null && codecCapabilities.colorFormats.length > 0) {
                    info = info + "----- Video info -----\n";
                    info = info + "Supported colors: \n";
                    for (MediaCodecInfo.EncoderCapabilities color : (MediaCodecInfo.CodecProfileLevel[])codecCapabilities.colorFormats) {
                        info = info + (int)color + "\n";
                    }
                    encoderCapabilities = codecCapabilities.profileLevels;
                    int n2 = encoderCapabilities.length;
                    for (n = 0; n < n2; ++n) {
                        MediaCodecInfo.CodecProfileLevel profile = encoderCapabilities[n];
                        info = info + "Profile: " + profile.profile + ", level: " + profile.level + "\n";
                    }
                    videoCapabilities = codecCapabilities.getVideoCapabilities();
                    info = info + "Bitrate range: " + videoCapabilities.getBitrateRange().getLower() + " - " + videoCapabilities.getBitrateRange().getUpper() + "\n";
                    info = info + "Frame rate range: " + videoCapabilities.getSupportedFrameRates().getLower() + " - " + videoCapabilities.getSupportedFrameRates().getUpper() + "\n";
                    info = info + "Width range: " + videoCapabilities.getSupportedWidths().getLower() + " - " + videoCapabilities.getSupportedWidths().getUpper() + "\n";
                    info = info + "Height range: " + videoCapabilities.getSupportedHeights().getLower() + " - " + videoCapabilities.getSupportedHeights().getUpper() + "\n";
                    info = info + "----- -----\n";
                } else {
                    info = info + "----- Audio info -----\n";
                    videoCapabilities = codecCapabilities.profileLevels;
                    int n3 = ((MediaCodecInfo.CodecProfileLevel[])videoCapabilities).length;
                    for (n = 0; n < n3; ++n) {
                        MediaCodecInfo.CodecProfileLevel profile = videoCapabilities[n];
                        info = info + "Profile: " + profile.profile + ", level: " + profile.level + "\n";
                    }
                    MediaCodecInfo.AudioCapabilities audioCapabilities = codecCapabilities.getAudioCapabilities();
                    info = info + "Bitrate range: " + audioCapabilities.getBitrateRange().getLower() + " - " + audioCapabilities.getBitrateRange().getUpper() + "\n";
                    info = info + "Channels supported: " + audioCapabilities.getMaxInputChannelCount() + "\n";
                    try {
                        if (audioCapabilities.getSupportedSampleRates() != null && audioCapabilities.getSupportedSampleRates().length > 0) {
                            info = info + "Supported sample rate: \n";
                            int[] nArray = audioCapabilities.getSupportedSampleRates();
                            n = nArray.length;
                            for (int i = 0; i < n; ++i) {
                                int sr = nArray[i];
                                info = info + sr + "\n";
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    info = info + "----- -----\n";
                }
                info = info + "Max instances: " + codecCapabilities.getMaxSupportedInstances() + "\n";
            }
            info = info + "----------------\n";
            infos.add(info);
        }
        return infos;
    }

    public static List<MediaCodecInfo> getAllCodecs() {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        if (Build.VERSION.SDK_INT >= 21) {
            MediaCodecList mediaCodecList = new MediaCodecList(1);
            MediaCodecInfo[] mediaCodecInfos = mediaCodecList.getCodecInfos();
            mediaCodecInfoList.addAll(Arrays.asList(mediaCodecInfos));
        } else {
            int count = MediaCodecList.getCodecCount();
            for (int i = 0; i < count; ++i) {
                MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    public static List<MediaCodecInfo> getAllHardwareEncoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoHardware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (name.contains("omx.google") || name.contains("sw")) continue;
            mediaCodecInfoHardware.add(mediaCodecInfo);
        }
        return mediaCodecInfoHardware;
    }

    public static List<MediaCodecInfo> getAllHardwareDecoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllDecoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoHardware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (name.contains("omx.google") || name.contains("sw")) continue;
            mediaCodecInfoHardware.add(mediaCodecInfo);
        }
        return mediaCodecInfoHardware;
    }

    public static List<MediaCodecInfo> getAllSoftwareEncoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoSoftware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (!name.contains("omx.google") && !name.contains("sw")) continue;
            mediaCodecInfoSoftware.add(mediaCodecInfo);
        }
        return mediaCodecInfoSoftware;
    }

    public static List<MediaCodecInfo> getAllSoftwareDecoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllDecoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoSoftware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (!name.contains("omx.google") && !name.contains("sw")) continue;
            mediaCodecInfoSoftware.add(mediaCodecInfo);
        }
        return mediaCodecInfoSoftware;
    }

    public static List<MediaCodecInfo> getAllEncoders(String mime) {
        if (Build.VERSION.SDK_INT >= 21) {
            return CodecUtil.getAllEncodersAPI21(mime);
        }
        return CodecUtil.getAllEncodersAPI16(mime);
    }

    public static List<MediaCodecInfo> getAllDecoders(String mime) {
        if (Build.VERSION.SDK_INT >= 21) {
            return CodecUtil.getAllDecodersAPI21(mime);
        }
        return CodecUtil.getAllDecodersAPI16(mime);
    }

    @RequiresApi(api=21)
    private static List<MediaCodecInfo> getAllEncodersAPI21(String mime) {
        MediaCodecInfo[] mediaCodecInfos;
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        for (MediaCodecInfo mci : mediaCodecInfos = mediaCodecList.getCodecInfos()) {
            String[] types;
            if (!mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    private static List<MediaCodecInfo> getAllEncodersAPI16(String mime) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        int count = MediaCodecList.getCodecCount();
        for (int i = 0; i < count; ++i) {
            String[] types;
            MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
            if (!mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    @RequiresApi(api=21)
    private static List<MediaCodecInfo> getAllDecodersAPI21(String mime) {
        MediaCodecInfo[] mediaCodecInfos;
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        for (MediaCodecInfo mci : mediaCodecInfos = mediaCodecList.getCodecInfos()) {
            String[] types;
            if (mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    private static List<MediaCodecInfo> getAllDecodersAPI16(String mime) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        int count = MediaCodecList.getCodecCount();
        for (int i = 0; i < count; ++i) {
            String[] types;
            MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
            if (mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    public static enum Force {
        FIRST_COMPATIBLE_FOUND,
        SOFTWARE,
        HARDWARE;

    }
}

