/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CodecUtil {
    private static final String TAG = "CodecUtil";
    public static final String H264_MIME = "video/avc";
    public static final String H265_MIME = "video/hevc";
    public static final String AAC_MIME = "audio/mp4a-latm";

    public static List<MediaCodecInfo> getAllCodecs() {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        if (Build.VERSION.SDK_INT >= 21) {
            MediaCodecList mediaCodecList = new MediaCodecList(1);
            MediaCodecInfo[] mediaCodecInfos = mediaCodecList.getCodecInfos();
            mediaCodecInfoList.addAll(Arrays.asList(mediaCodecInfos));
        } else {
            int count = MediaCodecList.getCodecCount();
            for (int i = 0; i < count; ++i) {
                MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    public static List<MediaCodecInfo> getAllHardwareEncoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoHardware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (name.contains("omx.google") || name.contains("sw")) continue;
            mediaCodecInfoHardware.add(mediaCodecInfo);
        }
        return mediaCodecInfoHardware;
    }

    public static List<MediaCodecInfo> getAllHardwareDecoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllDecoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoHardware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (name.contains("omx.google") || name.contains("sw")) continue;
            mediaCodecInfoHardware.add(mediaCodecInfo);
        }
        return mediaCodecInfoHardware;
    }

    public static List<MediaCodecInfo> getAllSoftwareEncoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoSoftware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (!name.contains("omx.google") && !name.contains("sw")) continue;
            mediaCodecInfoSoftware.add(mediaCodecInfo);
        }
        return mediaCodecInfoSoftware;
    }

    public static List<MediaCodecInfo> getAllSoftwareDecoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllDecoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoSoftware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (!name.contains("omx.google") && !name.contains("sw")) continue;
            mediaCodecInfoSoftware.add(mediaCodecInfo);
        }
        return mediaCodecInfoSoftware;
    }

    public static List<MediaCodecInfo> getAllEncoders(String mime) {
        if (Build.VERSION.SDK_INT >= 21) {
            return CodecUtil.getAllEncodersAPI21(mime);
        }
        return CodecUtil.getAllEncodersAPI16(mime);
    }

    public static List<MediaCodecInfo> getAllDecoders(String mime) {
        if (Build.VERSION.SDK_INT >= 21) {
            return CodecUtil.getAllDecodersAPI21(mime);
        }
        return CodecUtil.getAllDecodersAPI16(mime);
    }

    @RequiresApi(api=21)
    private static List<MediaCodecInfo> getAllEncodersAPI21(String mime) {
        MediaCodecInfo[] mediaCodecInfos;
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        for (MediaCodecInfo mci : mediaCodecInfos = mediaCodecList.getCodecInfos()) {
            String[] types;
            if (!mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    private static List<MediaCodecInfo> getAllEncodersAPI16(String mime) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        int count = MediaCodecList.getCodecCount();
        for (int i = 0; i < count; ++i) {
            String[] types;
            MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
            if (!mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    @RequiresApi(api=21)
    private static List<MediaCodecInfo> getAllDecodersAPI21(String mime) {
        MediaCodecInfo[] mediaCodecInfos;
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        for (MediaCodecInfo mci : mediaCodecInfos = mediaCodecList.getCodecInfos()) {
            String[] types;
            if (mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    private static List<MediaCodecInfo> getAllDecodersAPI16(String mime) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        int count = MediaCodecList.getCodecCount();
        for (int i = 0; i < count; ++i) {
            String[] types;
            MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
            if (mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    public static enum Force {
        FIRST_COMPATIBLE_FOUND,
        SOFTWARE,
        HARDWARE;

    }
}

