/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.support.annotation.RequiresApi;
import android.view.Surface;
import com.pedro.encoder.input.gl.render.CameraRender;
import com.pedro.encoder.input.gl.render.RenderHandler;
import com.pedro.encoder.input.gl.render.ScreenRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.NoFilterRender;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(api=18)
public class ManagerRender {
    public static int numFilters = 1;
    private CameraRender cameraRender;
    private List<BaseFilterRender> baseFilterRender = new ArrayList<BaseFilterRender>(numFilters);
    private ScreenRender screenRender;
    private int width;
    private int height;
    private Context context;

    public ManagerRender() {
        this.cameraRender = new CameraRender();
        for (int i = 0; i < numFilters; ++i) {
            this.baseFilterRender.add(new NoFilterRender());
        }
        this.screenRender = new ScreenRender();
    }

    public void initGl(Context context) {
        this.context = context;
        this.cameraRender.initGl(this.width, this.height, context);
        for (int i = 0; i < numFilters; ++i) {
            int textId = i == 0 ? this.cameraRender.getTexId() : this.baseFilterRender.get(i - 1).getTexId();
            this.baseFilterRender.get(i).setPreviousTexId(textId);
            this.baseFilterRender.get(i).initGl(this.width, this.height, context);
            this.baseFilterRender.get(i).initFBOLink();
        }
        this.screenRender.setTexId(this.baseFilterRender.get(numFilters - 1).getTexId());
        this.screenRender.initGl(context);
    }

    public void drawOffScreen() {
        this.cameraRender.draw();
        for (BaseFilterRender baseFilterRender : this.baseFilterRender) {
            baseFilterRender.draw();
        }
    }

    public void drawScreen(int width, int height, boolean keepAspectRatio) {
        this.screenRender.draw(width, height, keepAspectRatio);
    }

    public void release() {
        this.cameraRender.release();
        for (BaseFilterRender baseFilterRender : this.baseFilterRender) {
            baseFilterRender.release();
        }
        this.screenRender.release();
    }

    public void enableAA(boolean AAEnabled) {
        this.screenRender.setAAEnabled(AAEnabled);
    }

    public boolean isAAEnabled() {
        return this.screenRender.isAAEnabled();
    }

    public void updateFrame() {
        this.cameraRender.updateTexImage();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.cameraRender.getSurfaceTexture();
    }

    public Surface getSurface() {
        return this.cameraRender.getSurface();
    }

    public void setFilter(int position, BaseFilterRender baseFilterRender) {
        int id = this.baseFilterRender.get(position).getPreviousTexId();
        RenderHandler renderHandler = this.baseFilterRender.get(position).getRenderHandler();
        this.baseFilterRender.get(position).release();
        this.baseFilterRender.set(position, baseFilterRender);
        this.baseFilterRender.get(position).initGl(this.width, this.height, this.context);
        this.baseFilterRender.get(position).setPreviousTexId(id);
        this.baseFilterRender.get(position).setRenderHandler(renderHandler);
    }

    public void setStreamSize(int encoderWidth, int encoderHeight) {
        this.width = encoderWidth;
        this.height = encoderHeight;
        this.screenRender.setStreamSize(encoderWidth, encoderHeight);
    }

    public void setCameraRotation(int rotation) {
        this.cameraRender.setRotation(rotation);
    }

    public void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.cameraRender.setFlip(isFlipHorizontal, isFlipVertical);
    }
}

