/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.RequiresApi;
import com.pedro.encoder.utils.gl.GifStreamObject;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.TextStreamObject;

@RequiresApi(api=18)
public class TextureLoader {
    private TextStreamObject textStreamObject;
    private GifStreamObject gifStreamObject;
    private ImageStreamObject imageStreamObject;
    private int[] textureId;

    public void setTextStreamObject(TextStreamObject textStreamObject) {
        this.textStreamObject = textStreamObject;
        this.gifStreamObject = null;
        this.imageStreamObject = null;
    }

    public void setGifStreamObject(GifStreamObject gifStreamObject) {
        this.gifStreamObject = gifStreamObject;
        this.textStreamObject = null;
        this.imageStreamObject = null;
    }

    public void setImageStreamObject(ImageStreamObject imageStreamObject) {
        this.imageStreamObject = imageStreamObject;
        this.gifStreamObject = null;
        this.textStreamObject = null;
    }

    public int[] load() {
        if (this.textStreamObject != null) {
            this.textureId = new int[this.textStreamObject.getNumFrames()];
            GlUtil.createTextures(this.textStreamObject.getNumFrames(), this.textureId, 0);
            GLES20.glBindTexture((int)3553, (int)this.textureId[0]);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.textStreamObject.getImageBitmap(), (int)0);
            this.textStreamObject.recycle();
        } else if (this.imageStreamObject != null) {
            this.textureId = new int[this.imageStreamObject.getNumFrames()];
            GlUtil.createTextures(this.imageStreamObject.getNumFrames(), this.textureId, 0);
            GLES20.glBindTexture((int)3553, (int)this.textureId[0]);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.imageStreamObject.getImageBitmap(), (int)0);
            this.imageStreamObject.recycle();
        } else if (this.gifStreamObject != null) {
            this.textureId = new int[this.gifStreamObject.getNumFrames()];
            GlUtil.createTextures(this.gifStreamObject.getNumFrames(), this.textureId, 0);
            for (int i = 0; i < this.gifStreamObject.getNumFrames(); ++i) {
                GLES20.glBindTexture((int)3553, (int)this.textureId[i]);
                GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.gifStreamObject.getGifBitmaps()[i], (int)0);
            }
            this.gifStreamObject.recycle();
        } else {
            this.textureId = new int[]{-1};
        }
        return this.textureId;
    }

    public void clear() {
    }
}

