/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt.packets.control.handshake.extension;

import com.pedro.common.ExtensionsKt;
import com.pedro.srt.srt.packets.control.handshake.extension.CipherType;
import com.pedro.srt.srt.packets.control.handshake.extension.StreamEncapsulationType;
import com.pedro.srt.utils.EncryptInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/pedro/srt/srt/packets/control/handshake/extension/KeyMaterialMessage;", "", "encryptInfo", "Lcom/pedro/srt/utils/EncryptInfo;", "streamEncapsulation", "Lcom/pedro/srt/srt/packets/control/handshake/extension/StreamEncapsulationType;", "<init>", "(Lcom/pedro/srt/utils/EncryptInfo;Lcom/pedro/srt/srt/packets/control/handshake/extension/StreamEncapsulationType;)V", "getData", "", "srt_release"})
public final class KeyMaterialMessage {
    @NotNull
    private final EncryptInfo encryptInfo;
    @NotNull
    private final StreamEncapsulationType streamEncapsulation;

    public KeyMaterialMessage(@NotNull EncryptInfo encryptInfo, @NotNull StreamEncapsulationType streamEncapsulation) {
        Intrinsics.checkNotNullParameter((Object)encryptInfo, (String)"encryptInfo");
        Intrinsics.checkNotNullParameter((Object)((Object)streamEncapsulation), (String)"streamEncapsulation");
        this.encryptInfo = encryptInfo;
        this.streamEncapsulation = streamEncapsulation;
    }

    public /* synthetic */ KeyMaterialMessage(EncryptInfo encryptInfo, StreamEncapsulationType streamEncapsulationType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            streamEncapsulationType = StreamEncapsulationType.MPEG_TS_SRT;
        }
        this(encryptInfo, streamEncapsulationType);
    }

    @NotNull
    public final byte[] getData() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int sVersionPacketType = 18;
        buffer.write(sVersionPacketType);
        buffer.write(32);
        buffer.write(41);
        int resv1KeyBasedEncryption = 0 | this.encryptInfo.getKeyBasedEncryption().getValue();
        buffer.write(resv1KeyBasedEncryption);
        ExtensionsKt.writeUInt32((OutputStream)buffer, (int)0);
        buffer.write(this.encryptInfo.getCipher().getValue());
        buffer.write(this.encryptInfo.getCipher() == CipherType.GCM ? 1 : 0);
        buffer.write(this.streamEncapsulation.getValue());
        buffer.write(0);
        ExtensionsKt.writeUInt16((OutputStream)buffer, (int)0);
        buffer.write(this.encryptInfo.getSalt().length / 4);
        buffer.write(this.encryptInfo.getKeyLength() / 4);
        buffer.write(this.encryptInfo.getSalt());
        buffer.write(this.encryptInfo.getKey());
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }
}

