/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt.packets.control.handshake.extension;

import com.pedro.common.ExtensionsKt;
import com.pedro.srt.srt.packets.SrtPacket;
import com.pedro.srt.srt.packets.control.handshake.extension.ExtensionContentFlag;
import com.pedro.srt.srt.packets.control.handshake.extension.ExtensionType;
import com.pedro.srt.srt.packets.control.handshake.extension.KeyMaterialMessage;
import com.pedro.srt.utils.EncryptInfo;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\nH\u00c2\u0003JG\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/pedro/srt/srt/packets/control/handshake/extension/HandshakeExtension;", "Lcom/pedro/srt/srt/packets/SrtPacket;", "version", "", "flags", "", "receiverDelay", "senderDelay", "path", "encryptInfo", "Lcom/pedro/srt/utils/EncryptInfo;", "<init>", "(Ljava/lang/String;IIILjava/lang/String;Lcom/pedro/srt/utils/EncryptInfo;)V", "write", "", "getVersionData", "", "fixPathData", "data", "reverseBlocks", "bytes", "", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "toString", "srt_release"})
@SourceDebugExtension(value={"SMAP\nHandshakeExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HandshakeExtension.kt\ncom/pedro/srt/srt/packets/control/handshake/extension/HandshakeExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1563#2:97\n1634#2,3:98\n1563#2:101\n1634#2,3:102\n1869#2,2:105\n*S KotlinDebug\n*F\n+ 1 HandshakeExtension.kt\ncom/pedro/srt/srt/packets/control/handshake/extension/HandshakeExtension\n*L\n61#1:97\n61#1:98,3\n91#1:101\n91#1:102,3\n91#1:105,2\n*E\n"})
public final class HandshakeExtension
extends SrtPacket {
    @NotNull
    private final String version;
    private final int flags;
    private final int receiverDelay;
    private final int senderDelay;
    @NotNull
    private final String path;
    @Nullable
    private final EncryptInfo encryptInfo;

    public HandshakeExtension(@NotNull String version, int flags, int receiverDelay, int senderDelay, @NotNull String path, @Nullable EncryptInfo encryptInfo) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.version = version;
        this.flags = flags;
        this.receiverDelay = receiverDelay;
        this.senderDelay = senderDelay;
        this.path = path;
        this.encryptInfo = encryptInfo;
    }

    public /* synthetic */ HandshakeExtension(String string, int n, int n2, int n3, String string2, EncryptInfo encryptInfo, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = "1.5.3";
        }
        if ((n4 & 2) != 0) {
            n = ExtensionContentFlag.REXMITFLG.getValue() | ExtensionContentFlag.CRYPT.getValue();
        }
        if ((n4 & 4) != 0) {
            n2 = 120;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x10) != 0) {
            string2 = "";
        }
        if ((n4 & 0x20) != 0) {
            encryptInfo = null;
        }
        this(string, n, n2, n3, string2, encryptInfo);
    }

    public final void write() {
        ExtensionsKt.writeUInt16((OutputStream)this.getBuffer(), (int)ExtensionType.SRT_CMD_HS_REQ.getValue());
        ExtensionsKt.writeUInt16((OutputStream)this.getBuffer(), (int)3);
        this.getBuffer().write(this.getVersionData(this.version));
        ExtensionsKt.writeUInt32((OutputStream)this.getBuffer(), (int)this.flags);
        ExtensionsKt.writeUInt16((OutputStream)this.getBuffer(), (int)this.receiverDelay);
        ExtensionsKt.writeUInt16((OutputStream)this.getBuffer(), (int)this.senderDelay);
        ExtensionsKt.writeUInt16((OutputStream)this.getBuffer(), (int)ExtensionType.SRT_CMD_SID.getValue());
        byte[] byArray = this.path.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] data = this.fixPathData(byArray);
        ExtensionsKt.writeUInt16((OutputStream)this.getBuffer(), (int)(data.length / 4));
        this.getBuffer().write(data);
        if (this.encryptInfo != null) {
            ExtensionsKt.writeUInt16((OutputStream)this.getBuffer(), (int)ExtensionType.SRT_CMD_KM_REQ.getValue());
            KeyMaterialMessage keyMaterialMessage = new KeyMaterialMessage(this.encryptInfo, null, 2, null);
            byte[] encryptedData = keyMaterialMessage.getData();
            ExtensionsKt.writeUInt16((OutputStream)this.getBuffer(), (int)(encryptedData.length / 4));
            this.getBuffer().write(encryptedData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] getVersionData(String version) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Integer.parseInt(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
        }
        List versionNumbers = (List)destination$iv$iv;
        int versionValue = ((Number)versionNumbers.get(0)).intValue() * 65536 + ((Number)versionNumbers.get(1)).intValue() * 256 + ((Number)versionNumbers.get(2)).intValue();
        byte[] bytes = new byte[]{(byte)(versionValue >>> 24 & 0xFF), (byte)(versionValue >>> 16 & 0xFF), (byte)(versionValue >>> 8 & 0xFF), (byte)(versionValue & 0xFF)};
        return bytes;
    }

    private final byte[] fixPathData(byte[] data) {
        byte[] byArray;
        int mod = data.length % 4;
        if (mod == 0) {
            byArray = this.reverseBlocks(ArraysKt.asList((byte[])data));
        } else {
            int n = 0;
            int n2 = 4 - mod;
            byte[] byArray2 = new byte[n2];
            while (n < n2) {
                int n3 = n++;
                byArray2[n3] = 0;
            }
            List bytesToAdd = ArraysKt.asList((byte[])byArray2);
            List list = CollectionsKt.toMutableList((Collection)ArraysKt.asList((byte[])data));
            list.addAll(bytesToAdd);
            byArray = this.reverseBlocks(list);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] reverseBlocks(List<Byte> bytes) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        List blocks = CollectionsKt.chunked((Iterable)bytes, (int)4);
        List result = new ArrayList();
        Iterable $this$map$iv = blocks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.reversed((Iterable)((Iterable)it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            result.addAll(it);
        }
        return CollectionsKt.toByteArray((Collection)result);
    }

    private final String component1() {
        return this.version;
    }

    private final int component2() {
        return this.flags;
    }

    private final int component3() {
        return this.receiverDelay;
    }

    private final int component4() {
        return this.senderDelay;
    }

    private final String component5() {
        return this.path;
    }

    private final EncryptInfo component6() {
        return this.encryptInfo;
    }

    @NotNull
    public final HandshakeExtension copy(@NotNull String version, int flags, int receiverDelay, int senderDelay, @NotNull String path, @Nullable EncryptInfo encryptInfo) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new HandshakeExtension(version, flags, receiverDelay, senderDelay, path, encryptInfo);
    }

    public static /* synthetic */ HandshakeExtension copy$default(HandshakeExtension handshakeExtension, String string, int n, int n2, int n3, String string2, EncryptInfo encryptInfo, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = handshakeExtension.version;
        }
        if ((n4 & 2) != 0) {
            n = handshakeExtension.flags;
        }
        if ((n4 & 4) != 0) {
            n2 = handshakeExtension.receiverDelay;
        }
        if ((n4 & 8) != 0) {
            n3 = handshakeExtension.senderDelay;
        }
        if ((n4 & 0x10) != 0) {
            string2 = handshakeExtension.path;
        }
        if ((n4 & 0x20) != 0) {
            encryptInfo = handshakeExtension.encryptInfo;
        }
        return handshakeExtension.copy(string, n, n2, n3, string2, encryptInfo);
    }

    @NotNull
    public String toString() {
        return "HandshakeExtension(version=" + this.version + ", flags=" + this.flags + ", receiverDelay=" + this.receiverDelay + ", senderDelay=" + this.senderDelay + ", path=" + this.path + ", encryptInfo=" + this.encryptInfo + ")";
    }

    public int hashCode() {
        int result = this.version.hashCode();
        result = result * 31 + Integer.hashCode(this.flags);
        result = result * 31 + Integer.hashCode(this.receiverDelay);
        result = result * 31 + Integer.hashCode(this.senderDelay);
        result = result * 31 + this.path.hashCode();
        result = result * 31 + (this.encryptInfo == null ? 0 : this.encryptInfo.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HandshakeExtension)) {
            return false;
        }
        HandshakeExtension handshakeExtension = (HandshakeExtension)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)handshakeExtension.version)) {
            return false;
        }
        if (this.flags != handshakeExtension.flags) {
            return false;
        }
        if (this.receiverDelay != handshakeExtension.receiverDelay) {
            return false;
        }
        if (this.senderDelay != handshakeExtension.senderDelay) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)handshakeExtension.path)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.encryptInfo, (Object)handshakeExtension.encryptInfo);
    }

    public HandshakeExtension() {
        this(null, 0, 0, 0, null, null, 63, null);
    }
}

