/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.packets;

import com.pedro.common.frame.MediaFrame;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.MpegType;
import com.pedro.srt.mpeg2ts.Pes;
import com.pedro.srt.mpeg2ts.PesType;
import com.pedro.srt.mpeg2ts.packets.BasePacket;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.srt.packets.data.PacketPosition;
import com.pedro.srt.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2(\u0010\f\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\rH\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/pedro/srt/mpeg2ts/packets/OpusPacket;", "Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "limitSize", "", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "<init>", "(ILcom/pedro/srt/mpeg2ts/psi/PsiManager;)V", "createAndSendPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetPacket", "resetInfo", "", "createControlHeader", "", "payloadLength", "srt_release"})
@SourceDebugExtension(value={"SMAP\nOpusPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpusPacket.kt\ncom/pedro/srt/mpeg2ts/packets/OpusPacket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1872#2,2:84\n1863#2,2:87\n1874#2:89\n1#3:86\n*S KotlinDebug\n*F\n+ 1 OpusPacket.kt\ncom/pedro/srt/mpeg2ts/packets/OpusPacket\n*L\n55#1:84,2\n58#1:87,2\n55#1:89\n*E\n"})
public final class OpusPacket
extends BasePacket {
    public OpusPacket(int limitSize, @NotNull PsiManager psiManager) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        super(psiManager, limitSize);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super List<MpegTsPacket>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer fixedBuffer = com.pedro.common.ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        int length = fixedBuffer.remaining();
        if (length < 0) {
            return Unit.INSTANCE;
        }
        byte[] header = this.createControlHeader(length);
        byte[] payload = new byte[length + header.length];
        fixedBuffer.get(payload, header.length, length);
        System.arraycopy(header, 0, payload, 0, header.length);
        short s = this.getPsiManager().getAudioPid();
        long l = mediaFrame.getInfo().getTimestamp();
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        Pes pes = new Pes(s, true, PesType.PRIVATE_STREAM_1, l, byteBuffer);
        List mpeg2tsPackets = MpegTsPacketizer.write$default(this.getMpegTsPacketizer(), CollectionsKt.listOf((Object)pes), false, 2, null);
        List chunked = CollectionsKt.chunked((Iterable)mpeg2tsPackets, (int)this.getChunkSize());
        List packets = new ArrayList();
        Iterable $this$forEachIndexed$iv = chunked;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object object2;
            void chunks;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            Iterable iterable = (Iterable)chunks;
            int n2 = 0;
            for (Object object2 : iterable) {
                void it;
                byte[] byArray = (byte[])object2;
                int n3 = n2;
                boolean bl2 = false;
                int n4 = ((void)it).length;
                n2 = n3 + n4;
            }
            int size = n2;
            ByteBuffer buffer = ByteBuffer.allocate(size);
            Iterable $this$forEach$iv = (Iterable)chunks;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                byte[] it = (byte[])element$iv;
                boolean bl3 = false;
                buffer.put(it);
            }
            PacketPosition packetPosition = PacketPosition.SINGLE;
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            packets.add(new MpegTsPacket(byArray, MpegType.AUDIO, packetPosition, true));
        }
        if (!((Collection)packets).isEmpty()) {
            Object object = callback.invoke((Object)packets, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void resetPacket(boolean resetInfo) {
    }

    private final byte[] createControlHeader(int payloadLength) {
        byte[] bytes = ExtensionsKt.toByteArray(payloadLength);
        byte[] header = new byte[2 + bytes.length];
        header[0] = 127;
        header[1] = -32;
        System.arraycopy(bytes, 0, header, 2, bytes.length);
        return header;
    }
}

