/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateChecker;
import com.pedro.common.BitrateManager;
import com.pedro.common.ConnectChecker;
import com.pedro.common.ExtensionsKt;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.Pid;
import com.pedro.srt.mpeg2ts.packets.AacPacket;
import com.pedro.srt.mpeg2ts.packets.BasePacket;
import com.pedro.srt.mpeg2ts.packets.H26XPacket;
import com.pedro.srt.mpeg2ts.packets.OpusPacket;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.mpeg2ts.service.Mpeg2TsService;
import com.pedro.srt.srt.CommandsManager;
import com.pedro.srt.srt.SrtSender;
import com.pedro.srt.utils.SrtSocket;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0012\u0018\u0000 ]2\u00020\u0001:\u0001]B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0015H\u0002J\"\u00105\u001a\u0002022\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u0001072\b\u00109\u001a\u0004\u0018\u000107J\u0016\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u0015J\u0016\u0010=\u001a\u0002022\u0006\u0010>\u001a\u0002072\u0006\u0010?\u001a\u00020@J\u0016\u0010A\u001a\u0002022\u0006\u0010B\u001a\u0002072\u0006\u0010?\u001a\u00020@J\u0006\u0010C\u001a\u000202J\u001c\u0010D\u001a\u00020 2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0082@\u00a2\u0006\u0002\u0010FJ\u0016\u0010G\u001a\u0002022\u0006\u0010H\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020\u00152\b\b\u0002\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u0002022\u0006\u0010N\u001a\u00020\rJ\u0006\u0010O\u001a\u00020\rJ\u0006\u0010P\u001a\u00020\rJ\u0006\u0010Q\u001a\u000202J\u0006\u0010R\u001a\u00020 J\u0006\u0010S\u001a\u00020 J\u0006\u0010T\u001a\u000202J\u0006\u0010U\u001a\u000202J\u0006\u0010V\u001a\u000202J\u0006\u0010W\u001a\u000202J\u000e\u0010X\u001a\u0002022\u0006\u0010Y\u001a\u00020\u0015J\u000e\u0010Z\u001a\u0002022\u0006\u0010[\u001a\u00020LJ\u0006\u0010\\\u001a\u00020LR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001e\u0010)\u001a\u00020 2\u0006\u0010(\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001e\u0010,\u001a\u00020 2\u0006\u0010(\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/pedro/srt/srt/SrtSender;", "", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "commandsManager", "Lcom/pedro/srt/srt/CommandsManager;", "<init>", "(Lcom/pedro/common/ConnectChecker;Lcom/pedro/srt/srt/CommandsManager;)V", "service", "Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "limitSize", "", "mpegTsPacketizer", "Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "audioPacket", "Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "h26XPacket", "Lcom/pedro/srt/mpeg2ts/packets/H26XPacket;", "running", "", "cacheSize", "job", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "audioFramesSent", "", "videoFramesSent", "socket", "Lcom/pedro/srt/utils/SrtSocket;", "getSocket", "()Lcom/pedro/srt/utils/SrtSocket;", "setSocket", "(Lcom/pedro/srt/utils/SrtSocket;)V", "value", "droppedAudioFrames", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "bitrateManager", "Lcom/pedro/common/BitrateManager;", "isEnableLogs", "setTrackConfig", "", "videoEnabled", "audioEnabled", "setVideoInfo", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "setAudioInfo", "sampleRate", "isStereo", "sendVideoFrame", "h264Buffer", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendAudioFrame", "aacBuffer", "start", "sendPackets", "packets", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "clear", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasCongestion", "percentUsed", "", "resizeCache", "newSize", "getCacheSize", "getItemsInCache", "clearCache", "getSentAudioFrames", "getSentVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "setLogs", "enable", "setBitrateExponentialFactor", "factor", "getBitrateExponentialFactor", "Companion", "srt_release"})
@SourceDebugExtension(value={"SMAP\nSrtSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SrtSender.kt\ncom/pedro/srt/srt/SrtSender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/pedro/common/ExtensionsKt\n*L\n1#1,273:1\n1863#2,2:274\n66#3,5:276\n66#3,5:281\n*S KotlinDebug\n*F\n+ 1 SrtSender.kt\ncom/pedro/srt/srt/SrtSender\n*L\n185#1:274,2\n126#1:276,5\n138#1:281,5\n*E\n"})
public final class SrtSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final CommandsManager commandsManager;
    @NotNull
    private final Mpeg2TsService service;
    @NotNull
    private final PsiManager psiManager;
    private final int limitSize;
    @NotNull
    private final MpegTsPacketizer mpegTsPacketizer;
    @NotNull
    private BasePacket audioPacket;
    @NotNull
    private final H26XPacket h26XPacket;
    private volatile boolean running;
    private int cacheSize;
    @Nullable
    private Job job;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private volatile BlockingQueue<List<MpegTsPacket>> queue;
    private long audioFramesSent;
    private long videoFramesSent;
    @Nullable
    private SrtSocket socket;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    @NotNull
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    @NotNull
    private static final String TAG = "SrtSender";

    /*
     * WARNING - void declaration
     */
    public SrtSender(@NotNull ConnectChecker connectChecker, @NotNull CommandsManager commandsManager) {
        void $this$psiManager_u24lambda_u240;
        PsiManager psiManager;
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)commandsManager, (String)"commandsManager");
        this.connectChecker = connectChecker;
        this.commandsManager = commandsManager;
        this.service = new Mpeg2TsService(0, 0, null, null, null, null, null, 127, null);
        PsiManager psiManager2 = psiManager = new PsiManager(this.service);
        SrtSender srtSender = this;
        boolean bl = false;
        $this$psiManager_u24lambda_u240.upgradePatVersion();
        $this$psiManager_u24lambda_u240.upgradeSdtVersion();
        srtSender.psiManager = psiManager;
        this.limitSize = this.commandsManager.getMTU() - 16;
        this.mpegTsPacketizer = new MpegTsPacketizer(this.psiManager);
        this.audioPacket = new AacPacket(this.limitSize, this.psiManager);
        this.h26XPacket = new H26XPacket(this.limitSize, this.psiManager);
        this.cacheSize = 200;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.queue = new LinkedBlockingQueue(this.cacheSize);
        this.bitrateManager = new BitrateManager((BitrateChecker)this.connectChecker);
        this.isEnableLogs = true;
    }

    @Nullable
    public final SrtSocket getSocket() {
        return this.socket;
    }

    public final void setSocket(@Nullable SrtSocket srtSocket) {
        this.socket = srtSocket;
    }

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    private final void setTrackConfig(boolean videoEnabled, boolean audioEnabled) {
        Pid.reset();
        this.service.clearTracks();
        if (audioEnabled) {
            this.service.addTrack(com.pedro.srt.utils.ExtensionsKt.toCodec(this.commandsManager.getAudioCodec()));
        }
        if (videoEnabled) {
            this.service.addTrack(com.pedro.srt.utils.ExtensionsKt.toCodec(this.commandsManager.getVideoCodec()));
        }
        this.service.generatePmt();
        this.psiManager.updateService(this.service);
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.h26XPacket.setVideoCodec(com.pedro.srt.utils.ExtensionsKt.toCodec(this.commandsManager.getVideoCodec()));
        this.h26XPacket.sendVideoInfo(sps, pps, vps);
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.commandsManager.getAudioCodec().ordinal()]) {
            case 1: {
                BasePacket basePacket = this.audioPacket = (BasePacket)new AacPacket(this.limitSize, this.psiManager);
                AacPacket aacPacket = basePacket instanceof AacPacket ? (AacPacket)basePacket : null;
                if (aacPacket != null) {
                    aacPacket.sendAudioInfo(sampleRate, isStereo);
                }
                break;
            }
            case 2: {
                this.audioPacket = new OpusPacket(this.limitSize, this.psiManager);
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Unsupported codec: " + this.commandsManager.getAudioCodec().name());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void sendVideoFrame(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.h26XPacket.createAndSendPacket(h264Buffer, info, (Function1<? super List<MpegTsPacket>, Unit>)((Function1)arg_0 -> SrtSender.sendVideoFrame$lambda$1(this, arg_0)));
        }
    }

    public final void sendAudioFrame(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.audioPacket.createAndSendPacket(aacBuffer, info, (Function1<? super List<MpegTsPacket>, Unit>)((Function1)arg_0 -> SrtSender.sendAudioFrame$lambda$2(this, arg_0)));
        }
    }

    public final void start() {
        this.bitrateManager.reset();
        this.queue.clear();
        this.setTrackConfig(!this.commandsManager.getVideoDisabled(), !this.commandsManager.getAudioDisabled());
        this.running = true;
        this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SrtSender this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        bytesSend = new Ref.LongRef();
                        BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, bytesSend, null){
                            int label;
                            final /* synthetic */ SrtSender this$0;
                            final /* synthetic */ Ref.LongRef $bytesSend;
                            {
                                this.this$0 = $receiver;
                                this.$bytesSend = $bytesSend;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 3 sources

                                        while (CoroutineScopeKt.isActive((CoroutineScope)SrtSender.access$getScope$p(this.this$0)) && SrtSender.access$getRunning$p(this.this$0)) {
                                            this.label = 1;
                                            v0 = SrtSender.access$getBitrateManager$p(this.this$0).calculateBitrate(this.$bytesSend.element * (long)8, (Continuation)this);
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl15
                                        }
                                        break;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        this.$bytesSend.element = 0L;
                                        this.label = 2;
                                        v1 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                                        if (v1 != var2_2) ** GOTO lbl5
                                        return var2_2;
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        ** GOTO lbl5
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
lbl9:
                        // 2 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)SrtSender.access$getScope$p(this.this$0)) && SrtSender.access$getRunning$p(this.this$0)) {
                            var5_6 = $this$launch;
                            var6_7 = this.this$0;
                            $i$a$-runCatching-SrtSender$start$1$error$1 = false;
                            this.L$0 = $this$launch;
                            this.L$1 = bytesSend;
                            this.L$2 = var6_7;
                            this.L$3 = null;
                            this.L$4 = null;
                            this.label = 1;
                            v0 = InterruptibleKt.runInterruptible$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1$lambda$0(com.pedro.srt.srt.SrtSender ), ()Ljava/util/List;)((SrtSender)var6_7), (Continuation)this, (int)1, null);
                            ** if (v0 != var16_2) goto lbl25
lbl24:
                            // 1 sources

                            return var16_2;
lbl25:
                            // 1 sources

                            ** GOTO lbl36
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-runCatching-SrtSender$start$1$error$1 = false;
                        var6_7 = (SrtSender)this.L$2;
                        bytesSend = (Ref.LongRef)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl36:
                        // 2 sources

                        mpegTsPackets = (List)v0;
                        isKey = ((MpegTsPacket)mpegTsPackets.get(0)).isKey();
                        psiPackets = SrtSender.access$getPsiManager$p(var6_7).checkSendInfo(isKey != false, SrtSender.access$getMpegTsPacketizer$p(var6_7));
                        var12_14 = bytesSend.element;
                        var14_15 = bytesSend;
                        this.L$0 = $this$launch;
                        this.L$1 = bytesSend;
                        this.L$2 = var6_7;
                        this.L$3 = mpegTsPackets;
                        this.L$4 = var14_15;
                        this.J$0 = var12_14;
                        this.label = 2;
                        v1 = SrtSender.access$sendPackets(var6_7, psiPackets, (Continuation)this);
                        ** if (v1 != var16_2) goto lbl51
lbl50:
                        // 1 sources

                        return var16_2;
lbl51:
                        // 1 sources

                        ** GOTO lbl64
                    }
                    case 2: {
                        $i$a$-runCatching-SrtSender$start$1$error$1 = false;
                        var12_14 = this.J$0;
                        var14_15 = (Ref.LongRef)this.L$4;
                        mpegTsPackets = (List)this.L$3;
                        var6_7 = (SrtSender)this.L$2;
                        bytesSend = (Ref.LongRef)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl64:
                        // 2 sources

                        var15_16 = v1;
                        var14_15.element = var12_14 + ((Number)var15_16).longValue();
                        var12_14 = bytesSend.element;
                        var14_15 = bytesSend;
                        Intrinsics.checkNotNull((Object)mpegTsPackets);
                        this.L$0 = $this$launch;
                        this.L$1 = bytesSend;
                        this.L$2 = var14_15;
                        this.L$3 = null;
                        this.L$4 = null;
                        this.J$0 = var12_14;
                        this.label = 3;
                        v2 = SrtSender.access$sendPackets(var6_7, mpegTsPackets, (Continuation)this);
                        ** if (v2 != var16_2) goto lbl79
lbl78:
                        // 1 sources

                        return var16_2;
lbl79:
                        // 1 sources

                        ** GOTO lbl90
                    }
                    case 3: {
                        $i$a$-runCatching-SrtSender$start$1$error$1 = false;
                        var12_14 = this.J$0;
                        var14_15 = (Ref.LongRef)this.L$2;
                        bytesSend = (Ref.LongRef)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl90:
                            // 2 sources

                            var15_16 = v2;
                            var14_15.element = var12_14 + ((Number)var15_16).longValue();
                            var7_8 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable var8_10) {
                            var7_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var8_10));
                        }
                        if ((error = Result.exceptionOrNull-impl((Object)var7_8)) == null) ** GOTO lbl9
                        this.L$0 = error;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.L$4 = null;
                        this.label = 4;
                        v3 = ExtensionsKt.onMainThread((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(com.pedro.srt.srt.SrtSender java.lang.Throwable ), ()Lkotlin/Unit;)((SrtSender)this.this$0, (Throwable)error), (Continuation)((Continuation)this));
                        if (v3 == var16_2) {
                            return var16_2;
                        }
                        ** GOTO lbl113
                    }
                    case 4: {
                        error = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl113:
                        // 2 sources

                        Log.e((String)"SrtSender", (String)"send error: ", (Throwable)error);
                        return Unit.INSTANCE;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final List invokeSuspend$lambda$1$lambda$0(SrtSender this$0) {
                return (List)SrtSender.access$getQueue$p(this$0).poll(1L, TimeUnit.SECONDS);
            }

            private static final Unit invokeSuspend$lambda$2(SrtSender this$0, Throwable $error) {
                SrtSender.access$getConnectChecker$p(this$0).onConnectionFailed("Error send packet, " + $error.getMessage());
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendPackets(List<MpegTsPacket> var1_1, Continuation<? super Long> $completion) {
        if (!($completion instanceof sendPackets.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ SrtSender this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SrtSender.access$sendPackets(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                bytesSend = new Ref.LongRef();
                $this$forEach$iv = (Iterable)packets;
                $i$f$forEach = false;
                var6_9 = $this$forEach$iv.iterator();
lbl16:
                // 2 sources

                while (var6_9.hasNext()) {
                    element$iv = var6_9.next();
                    mpegTsPacket = (MpegTsPacket)element$iv;
                    $i$a$-forEach-SrtSender$sendPackets$2 = false;
                    var11_14 = size = 0;
                    $continuation.L$0 = this;
                    $continuation.L$1 = bytesSend;
                    $continuation.L$2 = var6_9;
                    $continuation.L$3 = mpegTsPacket;
                    $continuation.I$0 = var11_14;
                    $continuation.label = 1;
                    v0 = this.commandsManager.writeData(mpegTsPacket, this.socket, (Continuation<? super Integer>)$continuation);
                    if (v0 == var15_5) {
                        return var15_5;
                    }
                    ** GOTO lbl42
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-SrtSender$sendPackets$2 = false;
                var11_14 = $continuation.I$0;
                mpegTsPacket = (MpegTsPacket)$continuation.L$3;
                var6_9 = (Iterator)$continuation.L$2;
                bytesSend = (Ref.LongRef)$continuation.L$1;
                this = (SrtSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl42:
                // 2 sources

                var12_15 = v0;
                size = var11_14 + ((Number)var12_15).intValue();
                if (this.isEnableLogs) {
                    Log.i((String)"SrtSender", (String)("wrote " + mpegTsPacket.getType().name() + " packet, size " + size));
                }
                bytesSend.element += (long)size;
                ** GOTO lbl16
            }
        }
        return Boxing.boxLong((long)bytesSend.element);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stop(boolean var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof stop.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SrtSender this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop(false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.running = false;
                this.psiManager.reset();
                this.service.clear();
                this.mpegTsPacketizer.reset();
                this.audioPacket.reset(clear != false);
                this.h26XPacket.reset(clear != false);
                this.resetSentAudioFrames();
                this.resetSentVideoFrames();
                this.resetDroppedAudioFrames();
                this.resetDroppedVideoFrames();
                v0 = this.job;
                if (v0 == null) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = JobKt.cancelAndJoin((Job)v0, (Continuation)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                break;
            }
            case 1: {
                this = (SrtSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        this.job = null;
        this.queue.clear();
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasCongestion(float percentUsed) throws IllegalArgumentException {
        float remaining;
        float capacity;
        if (percentUsed < 0.0f || percentUsed > 100.0f) {
            throw new IllegalArgumentException("the value must be in range 0 to 100");
        }
        float size = this.queue.size();
        return size >= (capacity = size + (remaining = (float)this.queue.remainingCapacity())) * (percentUsed / 100.0f);
    }

    public static /* synthetic */ boolean hasCongestion$default(SrtSender srtSender, float f, int n, Object object) throws IllegalArgumentException {
        if ((n & 1) != 0) {
            f = 20.0f;
        }
        return srtSender.hasCongestion(f);
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.queue.size() - this.queue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.queue.drainTo(tempQueue);
        this.queue = tempQueue;
    }

    public final int getCacheSize() {
        return this.cacheSize;
    }

    public final int getItemsInCache() {
        return this.queue.size();
    }

    public final void clearCache() {
        this.queue.clear();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    public final void setBitrateExponentialFactor(float factor) {
        this.bitrateManager.setExponentialFactor(factor);
    }

    public final float getBitrateExponentialFactor() {
        return this.bitrateManager.getExponentialFactor();
    }

    private static final Unit sendVideoFrame$lambda$1(SrtSender this$0, List mpegTsPackets) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)mpegTsPackets, (String)"mpegTsPackets");
        BlockingQueue<List<MpegTsPacket>> $this$trySend$iv = this$0.queue;
        boolean $i$f$trySend = false;
        try {
            $this$trySend$iv.add(mpegTsPackets);
            bl = true;
        }
        catch (IllegalStateException e$iv) {
            bl = false;
        }
        boolean result = bl;
        if (!result) {
            Log.i((String)TAG, (String)"Video frame discarded");
            long l = this$0.droppedVideoFrames;
            this$0.droppedVideoFrames = l + 1L;
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendAudioFrame$lambda$2(SrtSender this$0, List mpegTsPackets) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)mpegTsPackets, (String)"mpegTsPackets");
        BlockingQueue<List<MpegTsPacket>> $this$trySend$iv = this$0.queue;
        boolean $i$f$trySend = false;
        try {
            $this$trySend$iv.add(mpegTsPackets);
            bl = true;
        }
        catch (IllegalStateException e$iv) {
            bl = false;
        }
        boolean result = bl;
        if (!result) {
            Log.i((String)TAG, (String)"Audio frame discarded");
            long l = this$0.droppedAudioFrames;
            this$0.droppedAudioFrames = l + 1L;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(SrtSender $this) {
        return $this.scope;
    }

    public static final /* synthetic */ boolean access$getRunning$p(SrtSender $this) {
        return $this.running;
    }

    public static final /* synthetic */ BitrateManager access$getBitrateManager$p(SrtSender $this) {
        return $this.bitrateManager;
    }

    public static final /* synthetic */ BlockingQueue access$getQueue$p(SrtSender $this) {
        return $this.queue;
    }

    public static final /* synthetic */ PsiManager access$getPsiManager$p(SrtSender $this) {
        return $this.psiManager;
    }

    public static final /* synthetic */ MpegTsPacketizer access$getMpegTsPacketizer$p(SrtSender $this) {
        return $this.mpegTsPacketizer;
    }

    public static final /* synthetic */ Object access$sendPackets(SrtSender $this, List packets, Continuation $completion) {
        return $this.sendPackets(packets, (Continuation<? super Long>)$completion);
    }

    public static final /* synthetic */ ConnectChecker access$getConnectChecker$p(SrtSender $this) {
        return $this.connectChecker;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pedro/srt/srt/SrtSender$Companion;", "", "<init>", "()V", "TAG", "", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.AAC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.G711.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

