/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt.packets.control;

import com.pedro.srt.srt.packets.ControlPacket;
import com.pedro.srt.srt.packets.control.ControlType;
import com.pedro.srt.utils.ExtensionsKt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\b\u0010\u0017\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pedro/srt/srt/packets/control/Nak;", "Lcom/pedro/srt/srt/packets/ControlPacket;", "()V", "cifLostList", "", "", "addLostPacket", "", "sequenceNumber", "addLostPacketsRange", "minValue", "maxValue", "getNakPacketsLostList", "", "read", "input", "Ljava/io/InputStream;", "readBody", "toString", "", "write", "ts", "socketId", "writeBody", "srt_release"})
@SourceDebugExtension(value={"SMAP\nNak.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Nak.kt\ncom/pedro/srt/srt/packets/control/Nak\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1855#2,2:97\n1855#2,2:99\n*S KotlinDebug\n*F\n+ 1 Nak.kt\ncom/pedro/srt/srt/packets/control/Nak\n*L\n53#1:97,2\n85#1:99,2\n*E\n"})
public final class Nak
extends ControlPacket {
    @NotNull
    private final List<Integer> cifLostList = new ArrayList();

    public Nak() {
        super(ControlType.NAK, null, 0, 0, 0, 30, null);
    }

    public final void addLostPacket(int sequenceNumber) {
        this.cifLostList.add(sequenceNumber & Integer.MAX_VALUE);
        this.cifLostList.add(sequenceNumber & Integer.MAX_VALUE);
    }

    public final void addLostPacketsRange(int minValue, int maxValue) {
        this.cifLostList.add(minValue | Integer.MIN_VALUE);
        this.cifLostList.add(maxValue & Integer.MAX_VALUE);
    }

    public final void write(int ts, int socketId) {
        super.writeHeader(ts, socketId);
        this.writeBody();
    }

    public final void read(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.readHeader(input);
        this.readBody(input);
    }

    private final void writeBody() {
        if (this.cifLostList.isEmpty() || this.cifLostList.size() % 2 != 0) {
            throw new IllegalArgumentException("empty or not pair size list not allowed");
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)this.cifLostList, (int)2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List range = (List)element$iv;
            boolean bl = false;
            int indicator = ((Number)range.get(0)).intValue() >> 31 & 1;
            ExtensionsKt.writeUInt32(this.getBuffer(), ((Number)range.get(0)).intValue());
            if (indicator != 1) continue;
            ExtensionsKt.writeUInt32(this.getBuffer(), ((Number)range.get(1)).intValue());
        }
    }

    private final void readBody(InputStream input) {
        boolean isRange = false;
        while (input.available() >= 4) {
            int value = ExtensionsKt.readUInt32(input);
            int indicator = value >> 31 & 1;
            if (indicator == 0) {
                this.cifLostList.add(value);
                if (!isRange) {
                    this.cifLostList.add(value);
                }
                isRange = false;
                continue;
            }
            this.cifLostList.add(value);
            isRange = true;
        }
    }

    @NotNull
    public final List<Integer> getNakPacketsLostList() {
        List chunks = CollectionsKt.chunked((Iterable)this.cifLostList, (int)2);
        List values = new ArrayList();
        Iterable $this$forEach$iv = chunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List ranges = (List)element$iv;
            boolean bl = false;
            int validMinValue = ((Number)ranges.get(0)).intValue() & Integer.MAX_VALUE;
            int validMaxValue = ((Number)ranges.get(1)).intValue() & Integer.MAX_VALUE;
            values.addAll(CollectionsKt.toList((Iterable)((Iterable)new IntRange(validMinValue, validMaxValue))));
        }
        return values;
    }

    @Override
    @NotNull
    public String toString() {
        return "Nak(cifLostList=" + this.cifLostList + ")";
    }
}

