/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.utils;

import com.pedro.srt.srt.packets.SrtPacket;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pedro/srt/utils/SrtSocket;", "", "host", "", "port", "", "(Ljava/lang/String;I)V", "TAG", "packetSize", "socket", "Ljava/net/DatagramSocket;", "close", "", "connect", "isConnected", "", "isReachable", "readBuffer", "", "setPacketSize", "size", "write", "srtPacket", "Lcom/pedro/srt/srt/packets/SrtPacket;", "srt_release"})
public final class SrtSocket {
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String TAG;
    @Nullable
    private DatagramSocket socket;
    private int packetSize;

    public SrtSocket(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.TAG = "SrtSocket";
        this.packetSize = 1500;
    }

    public final void connect() {
        block0: {
            InetAddress address2 = InetAddress.getByName(this.host);
            DatagramSocket datagramSocket = this.socket = new DatagramSocket();
            if (datagramSocket == null) break block0;
            datagramSocket.connect(address2, this.port);
        }
    }

    public final void close() {
        DatagramSocket datagramSocket = this.socket;
        boolean bl = datagramSocket != null ? !datagramSocket.isClosed() : false;
        if (bl) {
            DatagramSocket datagramSocket2 = this.socket;
            if (datagramSocket2 != null) {
                datagramSocket2.close();
            }
            this.socket = null;
        }
    }

    public final boolean isConnected() {
        DatagramSocket datagramSocket = this.socket;
        return datagramSocket != null ? datagramSocket.isConnected() : false;
    }

    public final boolean isReachable() {
        Object object = this.socket;
        return object != null && (object = ((DatagramSocket)object).getInetAddress()) != null ? ((InetAddress)object).isReachable(5000) : false;
    }

    public final void setPacketSize(int size) {
        this.packetSize = size;
    }

    public final void write(@NotNull SrtPacket srtPacket) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)srtPacket, (String)"srtPacket");
            byte[] buffer = srtPacket.getData();
            DatagramPacket udpPacket = new DatagramPacket(buffer, buffer.length);
            DatagramSocket datagramSocket = this.socket;
            if (datagramSocket == null) break block0;
            datagramSocket.send(udpPacket);
        }
    }

    @NotNull
    public final byte[] readBuffer() {
        byte[] buffer = new byte[this.packetSize];
        DatagramPacket udpPacket = new DatagramPacket(buffer, buffer.length);
        DatagramSocket datagramSocket = this.socket;
        if (datagramSocket != null) {
            datagramSocket.receive(udpPacket);
        }
        byte[] byArray = udpPacket.getData();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
        return ArraysKt.sliceArray((byte[])byArray, (IntRange)RangesKt.until((int)0, (int)udpPacket.getLength()));
    }
}

