/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.utils;

import com.pedro.srt.utils.ConnectCheckerSrt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/pedro/srt/utils/BitrateManager;", "", "connectCheckerSrt", "Lcom/pedro/srt/utils/ConnectCheckerSrt;", "(Lcom/pedro/srt/utils/ConnectCheckerSrt;)V", "bitrate", "", "timeStamp", "calculateBitrate", "", "size", "srt_release"})
public class BitrateManager {
    @NotNull
    private final ConnectCheckerSrt connectCheckerSrt;
    private long bitrate;
    private long timeStamp;

    public BitrateManager(@NotNull ConnectCheckerSrt connectCheckerSrt) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerSrt, (String)"connectCheckerSrt");
        this.connectCheckerSrt = connectCheckerSrt;
        this.timeStamp = System.currentTimeMillis();
    }

    public final synchronized void calculateBitrate(long size) {
        this.bitrate += size;
        long timeDiff = System.currentTimeMillis() - this.timeStamp;
        if (timeDiff >= 1000L) {
            this.connectCheckerSrt.onNewBitrateSrt((long)((float)this.bitrate / ((float)timeDiff / 1000.0f)));
            this.timeStamp = System.currentTimeMillis();
            this.bitrate = 0L;
        }
    }
}

