/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts;

import com.pedro.srt.mpeg2ts.AdaptationField;
import com.pedro.srt.mpeg2ts.AdaptationFieldControl;
import com.pedro.srt.mpeg2ts.MpegTsPayload;
import com.pedro.srt.mpeg2ts.Pes;
import com.pedro.srt.mpeg2ts.psi.Psi;
import com.pedro.srt.utils.ExtensionsKt;
import com.pedro.srt.utils.TimeUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "", "()V", "pesContinuity", "", "reset", "", "write", "", "", "payload", "Lcom/pedro/srt/mpeg2ts/MpegTsPayload;", "writeHeader", "buffer", "Ljava/nio/ByteBuffer;", "startIndicator", "", "pid", "adaptationFieldControl", "Lcom/pedro/srt/mpeg2ts/AdaptationFieldControl;", "continuity", "writeStuffingBytes", "byteBuffer", "size", "addHeader", "Companion", "srt_release"})
@SourceDebugExtension(value={"SMAP\nMpegTsPacketizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MpegTsPacketizer.kt\ncom/pedro/srt/mpeg2ts/MpegTsPacketizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1864#2,3:133\n*S KotlinDebug\n*F\n+ 1 MpegTsPacketizer.kt\ncom/pedro/srt/mpeg2ts/MpegTsPacketizer\n*L\n58#1:133,3\n*E\n"})
public final class MpegTsPacketizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int pesContinuity;
    public static final int packetSize = 188;

    private final void writeHeader(ByteBuffer buffer, boolean startIndicator, int pid, AdaptationFieldControl adaptationFieldControl, int continuity) {
        boolean transportErrorIndicator = false;
        boolean transportPriority = false;
        int transportScramblingControl = 0;
        buffer.put((byte)71);
        short combined = (short)(ExtensionsKt.toInt(transportErrorIndicator) << 15 | ExtensionsKt.toInt(startIndicator) << 14 | ExtensionsKt.toInt(transportPriority) << 13 | pid);
        buffer.putShort(combined);
        byte combined2 = (byte)((transportScramblingControl & 3) << 6 | (adaptationFieldControl.getValue() & 3) << 4 | continuity & 0xF);
        buffer.put(combined2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<byte[]> write(@NotNull List<? extends MpegTsPayload> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        List packets = new ArrayList();
        Iterable $this$forEachIndexed$iv = payload;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ByteBuffer byteBuffer;
            void mpegTsPayload;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MpegTsPayload mpegTsPayload2 = (MpegTsPayload)item$iv;
            int index = n;
            boolean bl = false;
            ByteBuffer buffer = ByteBuffer.allocate(188);
            boolean isFirstPacket = index == 0;
            int continuity = 0;
            void var15_15 = mpegTsPayload;
            if (var15_15 instanceof Psi) {
                ByteBuffer byteBuffer2 = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer2);
                this.writeHeader(byteBuffer2, true, mpegTsPayload.getPid(), AdaptationFieldControl.PAYLOAD, continuity);
                void psi = mpegTsPayload;
                Psi psi2 = (Psi)psi;
                ByteBuffer byteBuffer3 = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer3);
                psi2.write(byteBuffer3);
                int stuffingSize = buffer.remaining();
                byteBuffer = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer);
                this.writeStuffingBytes(byteBuffer, stuffingSize, false);
                byteBuffer = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer);
                packets.add(ExtensionsKt.toByteArray(byteBuffer));
                continue;
            }
            if (!(var15_15 instanceof Pes)) continue;
            void pes = mpegTsPayload;
            AdaptationFieldControl adaptationFieldControl = AdaptationFieldControl.ADAPTATION_PAYLOAD;
            byteBuffer = buffer;
            Intrinsics.checkNotNull((Object)byteBuffer);
            this.writeHeader(byteBuffer, true, mpegTsPayload.getPid(), adaptationFieldControl, this.pesContinuity);
            AdaptationField adaptationField = new AdaptationField(false, mpegTsPayload.isKeyFrame(), false, TimeUtils.getCurrentTimeMicro(), null, null, null, null, null, 500, null);
            buffer.put(adaptationField.getData());
            Pes pes2 = (Pes)pes;
            ByteBuffer byteBuffer4 = buffer;
            Intrinsics.checkNotNull((Object)byteBuffer4);
            pes2.writeHeader(byteBuffer4);
            ByteBuffer data = ((Pes)pes).getBufferData();
            while (data.hasRemaining()) {
                if (isFirstPacket) {
                    isFirstPacket = false;
                    adaptationFieldControl = AdaptationFieldControl.PAYLOAD;
                } else {
                    ByteBuffer byteBuffer5 = buffer;
                    Intrinsics.checkNotNull((Object)byteBuffer5);
                    this.writeHeader(byteBuffer5, false, mpegTsPayload.getPid(), adaptationFieldControl, this.pesContinuity);
                }
                int size = Math.min(data.remaining(), buffer.remaining());
                if (size < buffer.remaining()) {
                    int stuffingSize = buffer.remaining() - data.remaining();
                    byte by = buffer.get(buffer.position() - 1);
                    buffer.position(buffer.position() - 1);
                    buffer.put((byte)(by | 0x20));
                    ByteBuffer byteBuffer6 = buffer;
                    Intrinsics.checkNotNull((Object)byteBuffer6);
                    this.writeStuffingBytes(byteBuffer6, stuffingSize, true);
                }
                buffer.put(data.array(), data.position(), size);
                data.position(data.position() + size);
                ByteBuffer byteBuffer7 = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer7);
                packets.add(ExtensionsKt.toByteArray(byteBuffer7));
                this.pesContinuity = this.pesContinuity + 1 & 0xF;
                buffer = ByteBuffer.allocate(188);
            }
        }
        return packets;
    }

    private final void writeStuffingBytes(ByteBuffer byteBuffer, int size, boolean addHeader) {
        int fillSize;
        int n = fillSize = addHeader ? size - 2 : size;
        if (fillSize == -1) {
            byteBuffer.put((byte)(size - 1));
        } else {
            int n2 = 0;
            byte[] byArray = new byte[fillSize];
            while (n2 < fillSize) {
                int n3 = n2++;
                byArray[n3] = -1;
            }
            byte[] bytes = byArray;
            if (addHeader) {
                byteBuffer.put((byte)(size - 1));
                byteBuffer.put((byte)0);
            }
            byteBuffer.put(bytes);
        }
    }

    public final void reset() {
        this.pesContinuity = 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer$Companion;", "", "()V", "packetSize", "", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

