/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp.commands;

import com.pedro.common.AudioUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005\u00a8\u0006\u0014"}, d2={"Lcom/pedro/rtsp/rtsp/commands/SdpBody;", "", "<init>", "()V", "createOpusBody", "", "trackAudio", "", "createG711Body", "sampleRate", "isStereo", "", "createAacBody", "createAV1Body", "trackVideo", "createH264Body", "sps", "pps", "createH265Body", "vps", "rtsp_release"})
public final class SdpBody {
    @NotNull
    public static final SdpBody INSTANCE = new SdpBody();

    private SdpBody() {
    }

    @NotNull
    public final String createOpusBody(int trackAudio) {
        int payload = 96 + trackAudio;
        return "m=audio 0 RTP/AVP " + payload + "\r\na=rtpmap:" + payload + " OPUS/48000/2\r\na=control:streamid=" + trackAudio + "\r\n";
    }

    @NotNull
    public final String createG711Body(int trackAudio, int sampleRate, boolean isStereo) {
        int channel = isStereo ? 2 : 1;
        int payload = 8;
        return "m=audio 0 RTP/AVP " + payload + "\r\na=rtpmap:" + payload + " PCMA/" + sampleRate + "/" + channel + "\r\na=control:streamid=" + trackAudio + "\r\n";
    }

    @NotNull
    public final String createAacBody(int trackAudio, int sampleRate, boolean isStereo) {
        int frequency = AudioUtils.INSTANCE.getFrequency(sampleRate);
        int channel = isStereo ? 2 : 1;
        int config = 0x1000 | (frequency & 0xF) << 7 | (channel & 0xF) << 3;
        int payload = 96 + trackAudio;
        return "m=audio 0 RTP/AVP " + payload + "\r\na=rtpmap:" + payload + " MPEG4-GENERIC/" + sampleRate + "/" + channel + "\r\na=fmtp:" + payload + " profile-level-id=1; mode=AAC-hbr; config=" + Integer.toHexString(config) + "; sizelength=13; indexlength=3; indexdeltalength=3\r\na=control:streamid=" + trackAudio + "\r\n";
    }

    @NotNull
    public final String createAV1Body(int trackVideo) {
        int payload = 96 + trackVideo;
        return "m=video 0 RTP/AVP " + payload + "\r\na=rtpmap:" + payload + " AV1/90000\r\na=fmtp:" + payload + " profile=0; level-idx=0;\r\na=control:streamid=" + trackVideo + "\r\n";
    }

    @NotNull
    public final String createH264Body(int trackVideo, @NotNull String sps, @NotNull String pps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        int payload = 96 + trackVideo;
        return "m=video 0 RTP/AVP " + payload + "\r\na=rtpmap:" + payload + " H264/90000\r\na=fmtp:" + payload + " packetization-mode=1; sprop-parameter-sets=" + sps + "," + pps + "\r\na=control:streamid=" + trackVideo + "\r\n";
    }

    @NotNull
    public final String createH265Body(int trackVideo, @NotNull String sps, @NotNull String pps, @NotNull String vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Intrinsics.checkNotNullParameter((Object)vps, (String)"vps");
        int payload = 96 + trackVideo;
        return "m=video 0 RTP/AVP " + payload + "\r\na=rtpmap:" + payload + " H265/90000\r\na=fmtp:" + payload + " packetization-mode=1; sprop-sps=" + sps + "; sprop-pps=" + pps + "; sprop-vps=" + vps + "\r\na=control:streamid=" + trackVideo + "\r\n";
    }
}

