/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateChecker;
import com.pedro.common.BitrateManager;
import com.pedro.common.ConnectChecker;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.VideoCodec;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtp.packets.AacPacket;
import com.pedro.rtsp.rtp.packets.Av1Packet;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.G711Packet;
import com.pedro.rtsp.rtp.packets.H264Packet;
import com.pedro.rtsp.rtp.packets.H265Packet;
import com.pedro.rtsp.rtp.packets.OpusPacket;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtp.sockets.RtpSocketTcp;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.rtsp.RtspSender;
import com.pedro.rtsp.rtsp.commands.CommandsManager;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0012\u0018\u0000 [2\u00020\u0001:\u0001[B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,J\"\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001002\b\u00102\u001a\u0004\u0018\u000100J\u000e\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020\u0010J\u0016\u00105\u001a\u00020(2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209J\u0016\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0010J\u0016\u0010=\u001a\u00020(2\u0006\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0010J\u0016\u0010>\u001a\u00020(2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ\u0016\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ\u0006\u0010E\u001a\u00020(J\u000e\u0010F\u001a\u00020(H\u0086@\u00a2\u0006\u0002\u0010GJ\u0010\u0010H\u001a\u00020\u00122\b\b\u0002\u0010I\u001a\u00020JJ\u000e\u0010K\u001a\u00020(2\u0006\u0010L\u001a\u00020\u0010J\u0006\u0010M\u001a\u00020\u0010J\u0006\u0010N\u001a\u00020\u0010J\u0006\u0010O\u001a\u00020(J\u0006\u0010P\u001a\u00020\u001cJ\u0006\u0010Q\u001a\u00020\u001cJ\u0006\u0010R\u001a\u00020(J\u0006\u0010S\u001a\u00020(J\u0006\u0010T\u001a\u00020(J\u0006\u0010U\u001a\u00020(J\u000e\u0010V\u001a\u00020(2\u0006\u0010W\u001a\u00020\u0012J\u000e\u0010X\u001a\u00020(2\u0006\u0010Y\u001a\u00020JJ\u0006\u0010Z\u001a\u00020JR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/pedro/rtsp/rtsp/RtspSender;", "", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "commandsManager", "Lcom/pedro/rtsp/rtsp/commands/CommandsManager;", "<init>", "(Lcom/pedro/common/ConnectChecker;Lcom/pedro/rtsp/rtsp/commands/CommandsManager;)V", "videoPacket", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "audioPacket", "rtpSocket", "Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "baseSenderReport", "Lcom/pedro/rtsp/rtcp/BaseSenderReport;", "cacheSize", "", "running", "", "job", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "audioFramesSent", "", "videoFramesSent", "value", "droppedAudioFrames", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "bitrateManager", "Lcom/pedro/common/BitrateManager;", "isEnableLogs", "setSocketsInfo", "", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "videoSourcePorts", "", "audioSourcePorts", "setVideoInfo", "sps", "", "pps", "vps", "setAudioInfo", "sampleRate", "setDataStream", "outputStream", "Ljava/io/OutputStream;", "host", "", "setVideoPorts", "rtpPort", "rtcpPort", "setAudioPorts", "sendVideoFrame", "h264Buffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendAudioFrame", "aacBuffer", "start", "stop", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasCongestion", "percentUsed", "", "resizeCache", "newSize", "getCacheSize", "getItemsInCache", "clearCache", "getSentAudioFrames", "getSentVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "setLogs", "enable", "setBitrateExponentialFactor", "factor", "getBitrateExponentialFactor", "Companion", "rtsp_release"})
@SourceDebugExtension(value={"SMAP\nRtspSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtspSender.kt\ncom/pedro/rtsp/rtsp/RtspSender\n+ 2 Extensions.kt\ncom/pedro/common/ExtensionsKt\n*L\n1#1,288:1\n69#2,5:289\n69#2,5:294\n*S KotlinDebug\n*F\n+ 1 RtspSender.kt\ncom/pedro/rtsp/rtsp/RtspSender\n*L\n128#1:289,5\n140#1:294,5\n*E\n"})
public final class RtspSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final CommandsManager commandsManager;
    @Nullable
    private BasePacket videoPacket;
    @Nullable
    private BasePacket audioPacket;
    @Nullable
    private BaseRtpSocket rtpSocket;
    @Nullable
    private BaseSenderReport baseSenderReport;
    private int cacheSize;
    private volatile boolean running;
    @Nullable
    private Job job;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private volatile BlockingQueue<List<RtpFrame>> queue;
    private long audioFramesSent;
    private long videoFramesSent;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    @NotNull
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    @NotNull
    private static final String TAG = "RtspSender";

    public RtspSender(@NotNull ConnectChecker connectChecker, @NotNull CommandsManager commandsManager) {
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)commandsManager, (String)"commandsManager");
        this.connectChecker = connectChecker;
        this.commandsManager = commandsManager;
        this.cacheSize = 200;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.queue = new LinkedBlockingQueue(this.cacheSize);
        this.bitrateManager = new BitrateManager((BitrateChecker)this.connectChecker);
        this.isEnableLogs = true;
    }

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    public final void setSocketsInfo(@NotNull Protocol protocol, @NotNull int[] videoSourcePorts, @NotNull int[] audioSourcePorts) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)videoSourcePorts, (String)"videoSourcePorts");
        Intrinsics.checkNotNullParameter((Object)audioSourcePorts, (String)"audioSourcePorts");
        this.rtpSocket = BaseRtpSocket.Companion.getInstance(protocol, videoSourcePorts[0], audioSourcePorts[0]);
        this.baseSenderReport = BaseSenderReport.Companion.getInstance(protocol, videoSourcePorts[1], audioSourcePorts[1]);
    }

    public final void setVideoInfo(@NotNull byte[] sps, @Nullable byte[] pps, @Nullable byte[] vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.videoPacket = switch (WhenMappings.$EnumSwitchMapping$0[this.commandsManager.getVideoCodec().ordinal()]) {
            case 1 -> {
                if (pps == null) {
                    throw new IllegalArgumentException("pps can't be null with h264");
                }
                yield new H264Packet(sps, pps);
            }
            case 2 -> {
                if (vps == null || pps == null) {
                    throw new IllegalArgumentException("pps or vps can't be null with h265");
                }
                yield new H265Packet();
            }
            case 3 -> new Av1Packet();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void setAudioInfo(int sampleRate) {
        this.audioPacket = switch (WhenMappings.$EnumSwitchMapping$1[this.commandsManager.getAudioCodec().ordinal()]) {
            case 1 -> new G711Packet(sampleRate);
            case 2 -> new AacPacket(sampleRate);
            case 3 -> new OpusPacket(sampleRate);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) throws IOException {
        block1: {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            BaseRtpSocket baseRtpSocket = this.rtpSocket;
            if (baseRtpSocket != null) {
                baseRtpSocket.setDataStream(outputStream, host);
            }
            BaseSenderReport baseSenderReport = this.baseSenderReport;
            if (baseSenderReport == null) break block1;
            baseSenderReport.setDataStream(outputStream, host);
        }
    }

    public final void setVideoPorts(int rtpPort, int rtcpPort) {
        block0: {
            BasePacket basePacket = this.videoPacket;
            if (basePacket == null) break block0;
            basePacket.setPorts(rtpPort, rtcpPort);
        }
    }

    public final void setAudioPorts(int rtpPort, int rtcpPort) {
        block0: {
            BasePacket basePacket = this.audioPacket;
            if (basePacket == null) break block0;
            basePacket.setPorts(rtpPort, rtcpPort);
        }
    }

    public final void sendVideoFrame(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if (!this.running) break block1;
            BasePacket basePacket = this.videoPacket;
            if (basePacket != null) {
                basePacket.createAndSendPacket(h264Buffer, info, (Function1<? super List<RtpFrame>, Unit>)((Function1)arg_0 -> RtspSender.sendVideoFrame$lambda$0(this, arg_0)));
            }
        }
    }

    public final void sendAudioFrame(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if (!this.running) break block1;
            BasePacket basePacket = this.audioPacket;
            if (basePacket != null) {
                basePacket.createAndSendPacket(aacBuffer, info, (Function1<? super List<RtpFrame>, Unit>)((Function1)arg_0 -> RtspSender.sendAudioFrame$lambda$1(this, arg_0)));
            }
        }
    }

    public final void start() {
        this.bitrateManager.reset();
        this.queue.clear();
        long ssrcVideo = new Random().nextInt();
        long ssrcAudio = new Random().nextInt();
        BaseSenderReport baseSenderReport = this.baseSenderReport;
        if (baseSenderReport != null) {
            baseSenderReport.setSSRC(ssrcVideo, ssrcAudio);
        }
        BasePacket basePacket = this.videoPacket;
        if (basePacket != null) {
            basePacket.setSSRC(ssrcVideo);
        }
        BasePacket basePacket2 = this.audioPacket;
        if (basePacket2 != null) {
            basePacket2.setSSRC(ssrcAudio);
        }
        this.running = true;
        this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RtspSender this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                block24: {
                    var23_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            isTcp = RtspSender.access$getRtpSocket$p(this.this$0) instanceof RtpSocketTcp;
                            bytesSend = new Ref.LongRef();
                            BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, bytesSend, null){
                                int label;
                                final /* synthetic */ RtspSender this$0;
                                final /* synthetic */ Ref.LongRef $bytesSend;
                                {
                                    this.this$0 = $receiver;
                                    this.$bytesSend = $bytesSend;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object var1_1) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                            // 3 sources

                                            while (CoroutineScopeKt.isActive((CoroutineScope)RtspSender.access$getScope$p(this.this$0)) && RtspSender.access$getRunning$p(this.this$0)) {
                                                this.label = 1;
                                                v0 = RtspSender.access$getBitrateManager$p(this.this$0).calculateBitrate(this.$bytesSend.element * (long)8, (Continuation)this);
                                                if (v0 == var2_2) {
                                                    return var2_2;
                                                }
                                                ** GOTO lbl15
                                            }
                                            break;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl15:
                                            // 2 sources

                                            this.$bytesSend.element = 0L;
                                            this.label = 2;
                                            v1 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                                            if (v1 != var2_2) ** GOTO lbl5
                                            return var2_2;
                                        }
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
                                            ** GOTO lbl5
                                        }
                                    }
                                    return Unit.INSTANCE;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            break;
                        }
                        case 1: {
                            $i$a$-runCatching-RtspSender$start$1$error$1 = false;
                            isTcp = this.I$0;
                            var7_8 = (RtspSender)this.L$2;
                            bytesSend = (Ref.LongRef)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            while (true) {
                                frames = (List)v0;
                                size = new Ref.IntRef();
                                isVideo = new Ref.BooleanRef();
                                v1 = frames;
                                if (v1 == null) break block24;
                                $this$forEach$iv = v1;
                                $i$f$forEach = false;
                                var15_17 = $this$forEach$iv.iterator();
                                break;
                            }
                        }
                        case 2: {
                            $i$a$-runCatching-RtspSender$start$1$error$1 = false;
                            $i$f$forEach = false;
                            $i$a$-forEach-RtspSender$start$1$error$1$1 = false;
                            isTcp = this.I$0;
                            rtpFrame = (RtpFrame)this.L$6;
                            var15_17 = (Iterator)this.L$5;
                            isVideo = (Ref.BooleanRef)this.L$4;
                            size = (Ref.IntRef)this.L$3;
                            var7_8 = (RtspSender)this.L$2;
                            bytesSend = (Ref.LongRef)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            ** GOTO lbl117
                        }
                        case 3: {
                            $i$a$-runCatching-RtspSender$start$1$error$1 = false;
                            $i$f$forEach = false;
                            $i$a$-forEach-RtspSender$start$1$error$1$1 = false;
                            isTcp = this.I$0;
                            var15_17 = (Iterator<T>)this.L$5;
                            isVideo = (Ref.BooleanRef)this.L$4;
                            size = (Ref.IntRef)this.L$3;
                            var7_8 = (RtspSender)this.L$2;
                            bytesSend = (Ref.LongRef)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            while (true) {
                                v4 = ((Boolean)v3).booleanValue();
                                ** GOTO lbl143
                                break;
                            }
                        }
                        case 4: {
                            error = (Throwable)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl70:
                            // 2 sources

                            while (true) {
                                Log.e((String)"RtspSender", (String)"send error: ", (Throwable)error);
                                return Unit.INSTANCE;
                            }
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
lbl76:
                    // 2 sources

                    while (true) {
                        if (!CoroutineScopeKt.isActive((CoroutineScope)RtspSender.access$getScope$p(this.this$0)) || !RtspSender.access$getRunning$p(this.this$0)) return Unit.INSTANCE;
                        var6_7 = $this$launch;
                        var7_8 = this.this$0;
                        try {
                            $i$a$-runCatching-RtspSender$start$1$error$1 = false;
                            this.L$0 = $this$launch;
                            this.L$1 = bytesSend;
                            this.L$2 = var7_8;
                            this.L$3 = null;
                            this.L$4 = null;
                            this.L$5 = null;
                            this.L$6 = null;
                            this.I$0 = isTcp;
                            this.label = 1;
                            if ((v0 = InterruptibleKt.runInterruptible$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2$lambda$0(com.pedro.rtsp.rtsp.RtspSender ), ()Ljava/util/List;)((RtspSender)var7_8), (Continuation)this, (int)1, null)) != var23_2) ** continue;
                        }
                        catch (Throwable var9_11) {
                            var8_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var9_11));
                            continue;
                        }
                        return var23_2;
                    }
                    while (var15_17.hasNext()) {
                        element$iv = var15_17.next();
                        rtpFrame = (RtpFrame)element$iv;
                        $i$a$-forEach-RtspSender$start$1$error$1$1 = false;
                        v6 = RtspSender.access$getRtpSocket$p(var7_8);
                        if (v6 != null) {
                            this.L$0 = $this$launch;
                            this.L$1 = bytesSend;
                            this.L$2 = var7_8;
                            this.L$3 = size;
                            this.L$4 = isVideo;
                            this.L$5 = var15_17;
                            this.L$6 = rtpFrame;
                            this.I$0 = isTcp;
                            this.label = 2;
                            v2 = v6.sendFrame(rtpFrame, (Continuation<? super Unit>)this);
                            if (v2 == var23_2) {
                                return var23_2;
                            }
                        }
lbl117:
                        // 5 sources

                        packetSize = isTcp != 0 ? rtpFrame.getLength() + 4 : rtpFrame.getLength();
                        bytesSend.element += (long)packetSize;
                        size.element += packetSize;
                        isVideo.element = rtpFrame.isVideoFrame();
                        if (isVideo.element) {
                            var20_22 = RtspSender.access$getVideoFramesSent$p(var7_8);
                            RtspSender.access$setVideoFramesSent$p(var7_8, var20_22 + 1L);
                            v7 = var20_22;
                        } else {
                            var20_22 = RtspSender.access$getAudioFramesSent$p(var7_8);
                            RtspSender.access$setAudioFramesSent$p(var7_8, var20_22 + 1L);
                            v7 = var20_22;
                        }
                        v8 = RtspSender.access$getBaseSenderReport$p(var7_8);
                        if (v8 != null) {
                            this.L$0 = $this$launch;
                            this.L$1 = bytesSend;
                            this.L$2 = var7_8;
                            this.L$3 = size;
                            this.L$4 = isVideo;
                            this.L$5 = var15_17;
                            this.L$6 = null;
                            this.I$0 = isTcp;
                            this.label = 3;
                            if ((v3 = v8.update(rtpFrame, (Continuation<? super Boolean>)this)) != var23_2) ** continue;
                            return var23_2;
                        }
                        v4 = false;
lbl143:
                        // 2 sources

                        if (!v4) continue;
                        reportSize = isTcp != 0 ? 32 : 28;
                        bytesSend.element += (long)reportSize;
                        if (!RtspSender.access$isEnableLogs$p(var7_8)) continue;
                        Log.i((String)"RtspSender", (String)"wrote report");
                    }
                }
                if (RtspSender.access$isEnableLogs$p(var7_8)) {
                    type = isVideo.element != false ? "Video" : "Audio";
                    Log.i((String)"RtspSender", (String)("wrote " + type + " packet, size " + size.element));
                }
                var8_9 = Result.constructor-impl((Object)Unit.INSTANCE);
                ** while ((error = Result.exceptionOrNull-impl((Object)var8_9)) == null)
lbl159:
                // 1 sources

                this.L$0 = error;
                this.L$1 = null;
                this.L$2 = null;
                this.L$3 = null;
                this.L$4 = null;
                this.L$5 = null;
                this.L$6 = null;
                this.label = 4;
                ** while ((v5 = ExtensionsKt.onMainThread((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$3(com.pedro.rtsp.rtsp.RtspSender java.lang.Throwable ), ()Lkotlin/Unit;)((RtspSender)this.this$0, (Throwable)error), (Continuation)((Continuation)this))) != var23_2)
lbl168:
                // 1 sources

                return var23_2;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final List invokeSuspend$lambda$2$lambda$0(RtspSender this$0) {
                return (List)RtspSender.access$getQueue$p(this$0).poll(1L, TimeUnit.SECONDS);
            }

            private static final Unit invokeSuspend$lambda$3(RtspSender this$0, Throwable $error) {
                RtspSender.access$getConnectChecker$p(this$0).onConnectionFailed("Error send packet, " + $error.getMessage());
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof stop.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RtspSender this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.running = false;
                v0 = this.baseSenderReport;
                if (v0 != null) {
                    v0.reset();
                }
                v1 = this.baseSenderReport;
                if (v1 != null) {
                    v1.close();
                }
                v2 = this.rtpSocket;
                if (v2 != null) {
                    v2.close();
                }
                v3 = this.audioPacket;
                if (v3 != null) {
                    v3.reset();
                }
                v4 = this.videoPacket;
                if (v4 != null) {
                    v4.reset();
                }
                this.resetSentAudioFrames();
                this.resetSentVideoFrames();
                this.resetDroppedAudioFrames();
                this.resetDroppedVideoFrames();
                v5 = this.job;
                if (v5 == null) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v6 = JobKt.cancelAndJoin((Job)v5, (Continuation)$continuation);
                if (v6 == var4_4) {
                    return var4_4;
                }
                break;
            }
            case 1: {
                this = (RtspSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
                break;
            }
        }
        this.job = null;
        this.queue.clear();
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasCongestion(float percentUsed) throws IllegalArgumentException {
        float remaining;
        float capacity;
        if (percentUsed < 0.0f || percentUsed > 100.0f) {
            throw new IllegalArgumentException("the value must be in range 0 to 100");
        }
        float size = this.queue.size();
        return size >= (capacity = size + (remaining = (float)this.queue.remainingCapacity())) * (percentUsed / 100.0f);
    }

    public static /* synthetic */ boolean hasCongestion$default(RtspSender rtspSender, float f, int n, Object object) throws IllegalArgumentException {
        if ((n & 1) != 0) {
            f = 20.0f;
        }
        return rtspSender.hasCongestion(f);
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.queue.size() - this.queue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.queue.drainTo(tempQueue);
        this.queue = tempQueue;
    }

    public final int getCacheSize() {
        return this.cacheSize;
    }

    public final int getItemsInCache() {
        return this.queue.size();
    }

    public final void clearCache() {
        this.queue.clear();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    public final void setBitrateExponentialFactor(float factor) {
        this.bitrateManager.setExponentialFactor(factor);
    }

    public final float getBitrateExponentialFactor() {
        return this.bitrateManager.getExponentialFactor();
    }

    private static final Unit sendVideoFrame$lambda$0(RtspSender this$0, List rtpFrame) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        BlockingQueue<List<RtpFrame>> $this$trySend$iv = this$0.queue;
        boolean $i$f$trySend = false;
        try {
            $this$trySend$iv.add(rtpFrame);
            bl = true;
        }
        catch (IllegalStateException e$iv) {
            bl = false;
        }
        boolean result = bl;
        if (!result) {
            Log.i((String)TAG, (String)"Video frame discarded");
            long l = this$0.droppedVideoFrames;
            this$0.droppedVideoFrames = l + 1L;
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendAudioFrame$lambda$1(RtspSender this$0, List rtpFrame) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        BlockingQueue<List<RtpFrame>> $this$trySend$iv = this$0.queue;
        boolean $i$f$trySend = false;
        try {
            $this$trySend$iv.add(rtpFrame);
            bl = true;
        }
        catch (IllegalStateException e$iv) {
            bl = false;
        }
        boolean result = bl;
        if (!result) {
            Log.i((String)TAG, (String)"Audio frame discarded");
            long l = this$0.droppedAudioFrames;
            this$0.droppedAudioFrames = l + 1L;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ BaseRtpSocket access$getRtpSocket$p(RtspSender $this) {
        return $this.rtpSocket;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(RtspSender $this) {
        return $this.scope;
    }

    public static final /* synthetic */ boolean access$getRunning$p(RtspSender $this) {
        return $this.running;
    }

    public static final /* synthetic */ BitrateManager access$getBitrateManager$p(RtspSender $this) {
        return $this.bitrateManager;
    }

    public static final /* synthetic */ BlockingQueue access$getQueue$p(RtspSender $this) {
        return $this.queue;
    }

    public static final /* synthetic */ long access$getVideoFramesSent$p(RtspSender $this) {
        return $this.videoFramesSent;
    }

    public static final /* synthetic */ void access$setVideoFramesSent$p(RtspSender $this, long l) {
        $this.videoFramesSent = l;
    }

    public static final /* synthetic */ long access$getAudioFramesSent$p(RtspSender $this) {
        return $this.audioFramesSent;
    }

    public static final /* synthetic */ void access$setAudioFramesSent$p(RtspSender $this, long l) {
        $this.audioFramesSent = l;
    }

    public static final /* synthetic */ BaseSenderReport access$getBaseSenderReport$p(RtspSender $this) {
        return $this.baseSenderReport;
    }

    public static final /* synthetic */ boolean access$isEnableLogs$p(RtspSender $this) {
        return $this.isEnableLogs;
    }

    public static final /* synthetic */ ConnectChecker access$getConnectChecker$p(RtspSender $this) {
        return $this.connectChecker;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pedro/rtsp/rtsp/RtspSender$Companion;", "", "<init>", "()V", "TAG", "", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.G711.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.AAC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

