/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/pedro/rtsp/rtp/packets/OpusPacket;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "sampleRate", "", "<init>", "(I)V", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "callback", "Lkotlin/Function1;", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "rtsp_release"})
public final class OpusPacket
extends BasePacket {
    public OpusPacket(int sampleRate) {
        super(sampleRate, 96 + RtpConstants.INSTANCE.getTrackAudio());
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackAudio());
    }

    @Override
    public void createAndSendPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo bufferInfo, @NotNull Function1<? super RtpFrame, Unit> callback) {
        int size;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        int length = bufferInfo.size - byteBuffer.position();
        int maxPayload = this.getMaxPacketSize() - 12;
        long ts = bufferInfo.presentationTimeUs * (long)1000;
        for (int sum = 0; sum < length; sum += size) {
            size = length - sum < maxPayload ? length - sum : maxPayload;
            byte[] buffer = this.getBuffer(size + 12);
            byteBuffer.get(buffer, 12, size);
            this.markPacket(buffer);
            long rtpTs = this.updateTimeStamp(buffer, ts);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, 12 + size, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
            callback.invoke((Object)rtpFrame);
        }
    }
}

