/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/pedro/rtsp/rtp/sockets/RtpSocketTcp;", "Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "<init>", "()V", "outputStream", "Ljava/io/OutputStream;", "tcpHeader", "", "setDataStream", "", "host", "", "sendFrame", "rtpFrame", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "isEnableLogs", "", "(Lcom/pedro/rtsp/rtsp/RtpFrame;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "sendFrameTCP", "rtsp_release"})
public final class RtpSocketTcp
extends BaseRtpSocket {
    @Nullable
    private OutputStream outputStream;
    @NotNull
    private final byte[] tcpHeader;

    public RtpSocketTcp() {
        byte[] byArray = new byte[]{36, 0, 0, 0};
        this.tcpHeader = byArray;
    }

    @Override
    public void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.outputStream = outputStream;
    }

    @Override
    @Nullable
    public Object sendFrame(@NotNull RtpFrame rtpFrame, boolean isEnableLogs, @NotNull Continuation<? super Unit> $completion) throws IOException {
        this.sendFrameTCP(rtpFrame, isEnableLogs);
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendFrameTCP(RtpFrame rtpFrame, boolean isEnableLogs) throws IOException {
        Object object = RtpConstants.lock;
        synchronized (object) {
            boolean bl = false;
            int len = rtpFrame.getLength();
            this.tcpHeader[1] = (byte)(2 * rtpFrame.getChannelIdentifier());
            this.tcpHeader[2] = (byte)(len >> 8);
            this.tcpHeader[3] = (byte)(len & 0xFF);
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                outputStream.write(this.tcpHeader);
            }
            OutputStream outputStream2 = this.outputStream;
            if (outputStream2 != null) {
                outputStream2.write(rtpFrame.getBuffer(), 0, len);
            }
            OutputStream outputStream3 = this.outputStream;
            if (outputStream3 != null) {
                outputStream3.flush();
            }
            if (isEnableLogs) {
                Log.i((String)this.getTAG(), (String)("wrote packet: " + (rtpFrame.isVideoFrame() ? "Video" : "Audio") + ", size: " + (len + this.tcpHeader.length)));
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

