/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.common.ExtensionsKt;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lcom/pedro/rtsp/rtp/packets/H265Packet;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "()V", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "callback", "Lkotlin/Function1;", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "reset", "rtsp_release"})
public final class H265Packet
extends BasePacket {
    public H265Packet() {
        super(90000L, 96 + RtpConstants.INSTANCE.getTrackVideo());
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackVideo());
    }

    @Override
    public void createAndSendPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo bufferInfo, @NotNull Function1<? super RtpFrame, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)byteBuffer, (MediaCodec.BufferInfo)bufferInfo);
        byte[] header = new byte[com.pedro.rtsp.utils.ExtensionsKt.getVideoStartCodeSize(fixedBuffer) + 2];
        if (header.length == 2) {
            return;
        }
        fixedBuffer.get(header, 0, header.length);
        long ts = bufferInfo.presentationTimeUs * 1000L;
        int naluLength = fixedBuffer.remaining();
        int type = header[header.length - 2] >> 1;
        if (naluLength <= this.getMaxPacketSize() - 12 - 2) {
            byte[] buffer = this.getBuffer(naluLength + 12 + 2);
            buffer[12] = header[header.length - 2];
            buffer[13] = header[header.length - 1];
            fixedBuffer.get(buffer, 14, naluLength);
            long rtpTs = this.updateTimeStamp(buffer, ts);
            this.markPacket(buffer);
            this.updateSeq(buffer);
            RtpFrame rtpFrame2 = new RtpFrame(buffer, rtpTs, buffer.length, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
            callback.invoke((Object)rtpFrame2);
        } else {
            header[0] = 98;
            header[1] = 1;
            header[2] = (byte)type;
            header[2] = (byte)(header[2] + 128);
            int sum = 0;
            while (sum < naluLength) {
                int length = naluLength - sum > this.getMaxPacketSize() - 12 - 3 ? this.getMaxPacketSize() - 12 - 3 : fixedBuffer.remaining();
                byte[] buffer = this.getBuffer(length + 12 + 3);
                buffer[12] = header[0];
                buffer[13] = header[1];
                buffer[14] = header[2];
                long rtpTs = this.updateTimeStamp(buffer, ts);
                fixedBuffer.get(buffer, 15, length);
                if ((sum += length) >= naluLength) {
                    buffer[14] = (byte)(buffer[14] + 64);
                    this.markPacket(buffer);
                }
                this.updateSeq(buffer);
                RtpFrame rtpFrame3 = new RtpFrame(buffer, rtpTs, buffer.length, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
                callback.invoke((Object)rtpFrame3);
                header[2] = (byte)(header[2] & 0x7F);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
    }
}

